/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.api.matching.IItemMatcher;
import me.desht.modularrouters.api.matching.IModuleFlags;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;

public class RegexMatcher
implements IItemMatcher {
    private final List<Pattern> patterns;

    public RegexMatcher(List<String> regex) {
        this.patterns = Lists.newArrayListWithCapacity((int)regex.size());
        for (String r : regex) {
            try {
                Pattern pat = Pattern.compile(r, 2);
                this.patterns.add(pat);
            }
            catch (PatternSyntaxException e) {
                ModularRouters.LOGGER.warn("can't compile '" + r + "' - " + e.getMessage());
            }
        }
    }

    @Override
    public boolean matchItem(ItemStack stack, IModuleFlags flags) {
        if (stack.isEmpty()) {
            return false;
        }
        String name = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        return this.patterns.stream().anyMatch(pat -> pat.matcher(name).find());
    }
}

