/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.bookstate.BookStatesSaveData;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStates;
import com.klikli_dev.modonomicon.bookstate.BookVisualStates;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.networking.Message;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SyncBookUnlockStatesMessage
implements Message {
    public static final CustomPacketPayload.Type<SyncBookUnlockStatesMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"modonomicon", (String)"sync_book_unlock_states"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncBookUnlockStatesMessage> STREAM_CODEC = StreamCodec.composite(BookUnlockStates.STREAM_CODEC, m -> m.states, SyncBookUnlockStatesMessage::new);
    public BookUnlockStates states;

    public SyncBookUnlockStatesMessage(BookUnlockStates states) {
        this.states = states;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        if (minecraft.getSingleplayerServer() == null) {
            BookUnlockStateManager.get().saveData = new BookStatesSaveData(Map.of(player.getUUID(), this.states), (Map<UUID, BookVisualStates>)Object2ObjectMaps.emptyMap());
        }
        if (BookGuiManager.get().openBookParentScreen != null) {
            BookGuiManager.get().openBookParentScreen.onSyncBookUnlockStatesMessage(this);
        }
    }
}

