/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.entry;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookPaginatedScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.AddBookmarkButton;
import com.klikli_dev.modonomicon.client.gui.book.button.BackButton;
import com.klikli_dev.modonomicon.client.gui.book.button.RemoveBookmarkButton;
import com.klikli_dev.modonomicon.client.gui.book.button.SearchButton;
import com.klikli_dev.modonomicon.client.gui.book.entry.ContentRenderingScreen;
import com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler.BookLinkHandler;
import com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler.CommandLinkHandler;
import com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler.ItemLinkHandler;
import com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler.LinkHandler;
import com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler.PatchouliLinkHandler;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.fluid.FluidHolder;
import com.klikli_dev.modonomicon.integration.jei.ModonomiconJeiIntegration;
import com.klikli_dev.modonomicon.networking.AddBookmarkMessage;
import com.klikli_dev.modonomicon.networking.SyncBookVisualStatesMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.platform.services.FluidHelper;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BookEntryScreen
extends BookPaginatedScreen
implements ContentRenderingScreen {
    public static final int TOP_PADDING = 15;
    public static final int LEFT_PAGE_X = 12;
    public static final int RIGHT_PAGE_X = 141;
    public static final int SINGLE_PAGE_X = 12;
    public static final int PAGE_WIDTH = 124;
    public static final int PAGE_HEIGHT = 155;
    public static final int MAX_TITLE_WIDTH = 120;
    public static final int CLICK_SAFETY_MARGIN = 20;
    protected final BookParentScreen parentScreen;
    protected final BookContentEntry entry;
    protected final ResourceLocation bookContentTexture;
    protected int ticksInBook;
    protected List<BookPage> unlockedPages;
    protected int openPagesIndex;
    protected List<LinkHandler> linkHandlers;
    private List<Component> tooltip;
    private ItemStack tooltipStack;
    private FluidHolder tooltipFluidStack;
    private boolean isHoveringItemLink;

    public BookEntryScreen(BookParentScreen parentScreen, BookContentEntry entry) {
        super((Component)Component.literal((String)""));
        this.parentScreen = parentScreen;
        this.minecraft = Minecraft.getInstance();
        this.entry = entry;
        this.bookContentTexture = this.parentScreen.getBook().getBookContentTexture();
        this.unlockedPages = this.entry.getUnlockedPagesFor((Player)this.minecraft.player);
        this.linkHandlers = List.of(new BookLinkHandler(this), new PatchouliLinkHandler(this), new ItemLinkHandler(this), new CommandLinkHandler(this));
    }

    @Override
    public Book getBook() {
        return this.entry.getBook();
    }

    @Override
    public BookContentEntry getEntry() {
        return this.entry;
    }

    @Override
    public Font getFont() {
        return this.minecraft.font;
    }

    @Override
    public int getTicksInBook() {
        return this.ticksInBook;
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
        this.resetTooltip();
        this.tooltip = tooltip;
    }

    @Override
    public void setTooltipStack(ItemStack stack) {
        this.resetTooltip();
        this.tooltipStack = stack;
    }

    @Override
    public void setTooltipStack(FluidHolder stack) {
        this.resetTooltip();
        this.tooltipFluidStack = stack;
    }

    @Override
    public int getBookLeft() {
        return this.bookLeft;
    }

    @Override
    public int getBookTop() {
        return this.bookTop;
    }

    @Override
    public boolean isHoveringItemLink() {
        return this.isHoveringItemLink;
    }

    @Override
    public void isHoveringItemLink(boolean value) {
        this.isHoveringItemLink = value;
    }

    public int getCurrentPageNumber() {
        return this.unlockedPages.get(this.openPagesIndex).getPageNumber();
    }

    public void setOpenPagesIndex(int openPagesIndex) {
        this.openPagesIndex = openPagesIndex;
    }

    public void goToPage(int pageIndex, boolean playSound) {
        int openPagesIndex = this.getOpenPagesIndexForPage(pageIndex);
        if (openPagesIndex >= 0 && openPagesIndex < this.unlockedPages.size()) {
            if (this.openPagesIndex != openPagesIndex) {
                this.openPagesIndex = openPagesIndex;
                this.onPageChanged();
                if (playSound) {
                    BookContentRenderer.playTurnPageSound(this.getBook());
                }
            }
        } else {
            Modonomicon.LOG.warn("Tried to change to page index {} corresponding with openPagesIndex {} but max open pages index is {}.", new Object[]{pageIndex, openPagesIndex, this.unlockedPages.size()});
        }
    }

    protected Style getClickedComponentStyleAtForPage(BookPageRenderer<?> page, double pMouseX, double pMouseY) {
        if (page != null) {
            return page.getClickedComponentStyleAt(pMouseX - (double)this.bookLeft - (double)page.left, pMouseY - (double)this.bookTop - (double)page.top);
        }
        return null;
    }

    public void removeRenderableWidgets(@NotNull Collection<? extends Renderable> renderables) {
        this.renderables.removeIf(renderables::contains);
        this.children().removeIf(c -> c instanceof Renderable && renderables.contains(c));
        this.narratables.removeIf(n -> n instanceof Renderable && renderables.contains(n));
    }

    protected void drawTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltipStack != null) {
            List<Component> tooltip = this.getTooltipFromItem(this.tooltipStack);
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, tooltip, pMouseX, pMouseY);
        } else if (this.tooltipFluidStack != null) {
            List<Component> tooltip = this.getTooltipFromFluid(this.tooltipFluidStack);
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, tooltip, pMouseX, pMouseY);
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, this.tooltip, pMouseX, pMouseY);
        }
    }

    protected boolean clickPage(BookPageRenderer<?> page, double mouseX, double mouseY, int mouseButton) {
        if (page != null) {
            return page.mouseClicked(mouseX - (double)this.bookLeft - (double)page.left, mouseY - (double)this.bookTop - (double)page.top, mouseButton);
        }
        return false;
    }

    protected void renderPage(GuiGraphics guiGraphics, BookPageRenderer<?> page, int pMouseX, int pMouseY, float pPartialTick) {
        if (page == null) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)page.left, (float)page.top, 0.0f);
        page.render(guiGraphics, pMouseX - this.bookLeft - page.left, pMouseY - this.bookTop - page.top, pPartialTick);
        guiGraphics.pose().popPose();
    }

    protected void onPageChanged() {
        this.beginDisplayPages();
    }

    protected void resetTooltip() {
        this.tooltip = null;
        this.tooltipStack = null;
        this.tooltipFluidStack = null;
    }

    public void loadState(EntryVisualState state) {
        this.openPagesIndex = state.openPagesIndex;
    }

    public void saveState(EntryVisualState state, boolean savePage) {
        state.openPagesIndex = savePage ? this.openPagesIndex : 0;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 256) {
            BookGuiManager.get().closeScreenStack(this);
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public void onClose() {
        BookGuiManager.get().closeEntryScreen(this);
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T pWidget) {
        return (T)super.addRenderableWidget(pWidget);
    }

    public List<Component> getTooltipFromItem(ItemStack pItemStack) {
        List tooltip = BookEntryScreen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)pItemStack);
        if (this.isHoveringItemLink()) {
            tooltip.add(Component.literal((String)""));
            if (ModonomiconJeiIntegration.get().isLoaded()) {
                tooltip.add(Component.translatable((String)"modonomicon.gui.hover.item_link_info").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN)));
                tooltip.add(Component.translatable((String)"modonomicon.gui.hover.item_link_info_line2").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY)));
            } else {
                tooltip.add(Component.translatable((String)"modonomicon.gui.hover.item_link_info.no_jei").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.RED)));
            }
        }
        return tooltip;
    }

    public List<Component> getTooltipFromFluid(FluidHolder fluidStack) {
        List<Component> tooltip = ClientServices.FLUID.getTooltip(fluidStack, 1000, (TooltipFlag)(this.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL), FluidHelper.TooltipMode.SHOW_AMOUNT_AND_CAPACITY);
        if (this.isHoveringItemLink()) {
            tooltip.add((Component)Component.literal((String)""));
            if (ModonomiconJeiIntegration.get().isLoaded()) {
                tooltip.add((Component)Component.translatable((String)"modonomicon.gui.hover.item_link_info").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN)));
                tooltip.add((Component)Component.translatable((String)"modonomicon.gui.hover.item_link_info_line2").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY)));
            } else {
                tooltip.add((Component)Component.translatable((String)"modonomicon.gui.hover.item_link_info.no_jei").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.RED)));
            }
        }
        return tooltip;
    }

    public boolean handleComponentClicked(@Nullable Style pStyle) {
        if (pStyle != null) {
            for (LinkHandler handler : this.linkHandlers) {
                LinkHandler.ClickResult result = handler.handleClick(pStyle);
                if (result == LinkHandler.ClickResult.FAILURE) {
                    return true;
                }
                if (result != LinkHandler.ClickResult.SUCCESS) continue;
                return true;
            }
        }
        return super.handleComponentClicked(pStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.unlockedPages = this.entry.getUnlockedPagesFor((Player)this.minecraft.player);
        this.beginDisplayPages();
    }

    @Override
    protected void initNavigationButtons() {
        super.initNavigationButtons();
        this.addRenderableWidget(new BackButton(this, this.width / 2 - 9, this.bookTop + 180 - 4));
        this.updateBookmarksButton();
    }

    protected boolean isBookmarked() {
        return BookVisualStateManager.get().getBookmarksFor((Player)this.minecraft.player, this.entry.getBook()).stream().anyMatch(b -> b.entryId().equals((Object)this.entry.getId()));
    }

    protected void updateBookmarksButton() {
        this.renderables.removeIf(b -> b instanceof AddBookmarkButton || b instanceof SearchButton);
        this.children().removeIf(b -> b instanceof AddBookmarkButton || b instanceof SearchButton);
        this.narratables.removeIf(b -> b instanceof AddBookmarkButton || b instanceof SearchButton);
        int buttonHeight = 20;
        int searchButtonX = this.bookLeft + 272 - 5;
        int searchButtonY = this.bookTop + 180 - 30;
        int searchButtonWidth = 44;
        int scissorX = this.bookLeft + 272;
        if (this.isBookmarked()) {
            RemoveBookmarkButton removeBookMarkButton = new RemoveBookmarkButton(this, searchButtonX, searchButtonY, scissorX, searchButtonWidth, buttonHeight, b -> this.onRemoveBookmarksButtonClick((RemoveBookmarkButton)b), Tooltip.create((Component)Component.translatable((String)"modonomicon.gui.add_bookmark")));
            this.addRenderableWidget(removeBookMarkButton);
        } else {
            AddBookmarkButton addBookmarkButton = new AddBookmarkButton(this, searchButtonX, searchButtonY, scissorX, searchButtonWidth, buttonHeight, b -> this.onAddBookmarksButtonClick((AddBookmarkButton)b), Tooltip.create((Component)Component.translatable((String)"modonomicon.gui.add_bookmark")));
            this.addRenderableWidget(addBookmarkButton);
        }
    }

    protected void onAddBookmarksButtonClick(AddBookmarkButton button) {
        if (!this.isBookmarked()) {
            BookAddress bookmarkAddress = BookAddress.ignoreSaved(this.entry, this.getPageForOpenPagesIndex(this.openPagesIndex));
            BookVisualStateManager.get().addBookmarkFor((Player)this.minecraft.player, this.entry.getBook(), bookmarkAddress);
            Services.NETWORK.sendToServer(new AddBookmarkMessage(bookmarkAddress));
            this.updateBookmarksButton();
        }
    }

    protected void onRemoveBookmarksButtonClick(RemoveBookmarkButton button) {
        BookAddress bookmarkAddress = BookVisualStateManager.get().getBookmarksFor((Player)this.minecraft.player, this.entry.getBook()).stream().filter(b -> b.entryId().equals((Object)this.entry.getId())).findFirst().orElse(null);
        if (bookmarkAddress != null) {
            BookVisualStateManager.get().removeBookmarkFor((Player)this.minecraft.player, this.entry.getBook(), bookmarkAddress);
            this.updateBookmarksButton();
        }
    }

    public void tick() {
        super.tick();
        if (!BookEntryScreen.hasShiftDown()) {
            ++this.ticksInBook;
        }
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        Style style;
        if (pButton == 0 && (style = this.getClickedComponentStyleAt(pMouseX, pMouseY)) != null && this.handleComponentClicked(style)) {
            return true;
        }
        if (super.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return this.mouseClickedPage(pMouseX, pMouseY, pButton);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onSyncBookVisualStatesMessage(SyncBookVisualStatesMessage message) {
        this.updateBookmarksButton();
    }

    protected abstract int getOpenPagesIndexForPage(int var1);

    protected abstract int getPageForOpenPagesIndex(int var1);

    @Nullable
    protected abstract Style getClickedComponentStyleAt(double var1, double var3);

    protected abstract boolean mouseClickedPage(double var1, double var3, int var5);

    protected abstract void beginDisplayPages();
}

