/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.Message;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ClickCommandLinkMessage
implements Message {
    public static final CustomPacketPayload.Type<ClickCommandLinkMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"modonomicon", (String)"click_command_link"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClickCommandLinkMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, m -> m.bookId, (StreamCodec)ResourceLocation.STREAM_CODEC, m -> m.commandId, (StreamCodec)ResourceLocation.STREAM_CODEC, m -> m.entryId, ClickCommandLinkMessage::new);
    public ResourceLocation bookId;
    public ResourceLocation commandId;
    public ResourceLocation entryId;

    public ClickCommandLinkMessage(ResourceLocation bookId, ResourceLocation commandId, ResourceLocation entryId) {
        this.bookId = bookId;
        this.commandId = commandId;
        this.entryId = entryId;
    }

    public ClickCommandLinkMessage(ResourceLocation bookId, ResourceLocation commandId) {
        this(bookId, commandId, null);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        BookCommand command;
        Book book = BookDataManager.get().getBook(this.bookId);
        if (book != null && (command = book.getCommand(this.commandId)) != null) {
            if (this.entryId != null && !command.isEntryAllowed(this.entryId)) {
                player.sendSystemMessage((Component)Component.translatable((String)"modonomicon.command.failure_not_allowed_here").withStyle(ChatFormatting.RED));
                return;
            }
            command.execute(player);
        }
    }
}

