/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class CategoryLinkBookEntry
extends BookEntry {
    protected ResourceLocation categoryToOpenId;
    protected BookCategory categoryToOpen;

    public CategoryLinkBookEntry(ResourceLocation id, BookEntry.BookEntryData data, ResourceLocation commandToRunOnFirstReadId, ResourceLocation categoryToOpenId) {
        super(id, data, commandToRunOnFirstReadId);
        this.categoryToOpenId = categoryToOpenId;
    }

    public static CategoryLinkBookEntry fromJson(ResourceLocation id, JsonObject json, boolean autoAddReadConditions, HolderLookup.Provider provider) {
        String categoryToOpenIdPath;
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromJson(id, json, autoAddReadConditions, provider);
        ResourceLocation commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            commandToRunOnFirstReadId = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"command_to_run_on_first_read"));
        }
        ResourceLocation categoryToOpenId = (categoryToOpenIdPath = GsonHelper.getAsString((JsonObject)json, (String)"category_to_open")).contains(":") ? ResourceLocation.parse((String)categoryToOpenIdPath) : ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)categoryToOpenIdPath);
        return new CategoryLinkBookEntry(id, data, commandToRunOnFirstReadId, categoryToOpenId);
    }

    public static CategoryLinkBookEntry fromNetwork(RegistryFriendlyByteBuf buffer) {
        ResourceLocation id = buffer.readResourceLocation();
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromNetwork(buffer);
        ResourceLocation commandToRunOnFirstReadId = (ResourceLocation)buffer.readNullable(FriendlyByteBuf::readResourceLocation);
        ResourceLocation categoryToOpen = (ResourceLocation)buffer.readNullable(FriendlyByteBuf::readResourceLocation);
        return new CategoryLinkBookEntry(id, data, commandToRunOnFirstReadId, categoryToOpen);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.EntryType.CATEGORY_LINK;
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.id);
        this.data.toNetwork(buffer);
        buffer.writeNullable((Object)this.commandToRunOnFirstReadId, FriendlyByteBuf::writeResourceLocation);
        buffer.writeNullable((Object)this.categoryToOpenId, FriendlyByteBuf::writeResourceLocation);
    }

    @Override
    public void build(Level level, BookCategory category) {
        super.build(level, category);
        if (this.categoryToOpenId != null) {
            this.categoryToOpen = this.getBook().getCategory(this.categoryToOpenId);
            if (this.categoryToOpen == null) {
                BookErrorManager.get().error("Category to open \"" + String.valueOf(this.categoryToOpenId) + "\" does not exist in this book. Set to null.");
                this.categoryToOpenId = null;
            }
        }
    }

    public BookCategory getCategoryToOpen() {
        return this.categoryToOpen;
    }

    @Override
    public void openEntry(BookAddress address) {
        BookGuiManager.get().pushHistory(BookAddress.defaultFor(this.getCategory()));
        BookGuiManager.get().openCategoryLinkEntry(this);
    }
}

