/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.modlistmemory.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.terraformersmc.mod_menu.gui.widget.ModListWidget;
import com.terraformersmc.mod_menu.util.mod.Mod;
import dev.terminalmc.modlistmemory.config.Config;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModListWidget.class}, remap=false)
public class MixinModListWidget {
    @Inject(method={"setScrollAmount"}, at={@At(value="HEAD")})
    private void onSetScrollAmount(double amount, CallbackInfo ci) {
        Config.options().scrollAmount = amount;
    }

    @WrapOperation(method={"filter(Ljava/lang/String;ZZ)V"}, at={@At(value="INVOKE", target="Ljava/util/List;sort(Ljava/util/Comparator;)V")})
    private void wrapSort(List<Mod> modList, Comparator<? super Mod> comparator, Operation<Void> original) {
        original.call(new Object[]{modList, comparator});
        if (Config.options().mode.equals((Object)Config.Mode.REMEMBER_RECENT)) {
            ArrayList<Mod> copy = new ArrayList<Mod>(modList);
            modList.clear();
            Mod[] recentMods = new Mod[Config.options().recentMods.size()];
            Mod[] pinnedMods = new Mod[Config.options().pinnedMods.size()];
            for (Mod mod : copy) {
                int i = Config.options().pinnedMods.indexOf(mod.getId());
                if (i != -1) {
                    pinnedMods[i] = mod;
                    continue;
                }
                i = Config.options().recentMods.indexOf(mod.getId());
                if (i != -1) {
                    recentMods[i] = mod;
                    continue;
                }
                modList.add(mod);
            }
            for (Mod mod : recentMods) {
                if (mod == null) continue;
                modList.addFirst(mod);
            }
            for (Mod mod : pinnedMods) {
                if (mod == null) continue;
                modList.addFirst(mod);
            }
        }
    }
}

