/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.modlistmemory.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.terminalmc.modlistmemory.ModListMemory;
import dev.terminalmc.modlistmemory.platform.Services;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Path CONFIG_DIR = Services.PLATFORM.getConfigDir();
    private static final String FILE_NAME = "modlistmemory.json";
    private static final String BACKUP_FILE_NAME = "modlistmemory.unreadable.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Options options = new Options();
    private static Config instance = null;

    public static Options options() {
        return Config.get().options;
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    private void validate() {
    }

    @NotNull
    public static Config load() {
        Path file = CONFIG_DIR.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0]) && (config = Config.load(file, GSON)) == null) {
            Config.backup();
            ModListMemory.LOG.warn("Resetting config", new Object[0]);
        }
        return config != null ? config : new Config();
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ModListMemory.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup() {
        try {
            ModListMemory.LOG.warn("Copying {} to {}", FILE_NAME, BACKUP_FILE_NAME);
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(BACKUP_FILE_NAME);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ModListMemory.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.validate();
        try {
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            ModListMemory.onConfigSaved(instance);
        }
        catch (IOException e) {
            ModListMemory.LOG.error("Unable to save config", e);
        }
    }

    public static class Options {
        public static final Mode modeDefault = Mode.REMEMBER_RECENT;
        public Mode mode = modeDefault;
        public static final int pinnedModsSizeDefault = 5;
        public int pinnedModsSize = 5;
        public static final int recentModsSizeDefault = 5;
        public int recentModsSize = 5;
        public static final Key pinKeyDefault = Key.SHIFT;
        public Key pinKey = pinKeyDefault;
        public static final Key unpinKeyDefault = Key.CONTROL;
        public Key unpinKey = unpinKeyDefault;
        public static final boolean showBadgesDefault = true;
        public boolean showBadges = true;
        public static final String pinnedTextDefault = "I";
        public String pinnedText = "I";
        public static final String recentTextDefault = "R";
        public String recentText = "R";
        public static final boolean persistOnRestartDefault = true;
        public boolean persistOnRestart = true;
        public static final boolean saveOnUpdateDefault = true;
        public boolean saveOnUpdate = true;
        public static final List<String> pinnedModsDefault = new ArrayList<String>();
        public List<String> pinnedMods = pinnedModsDefault;
        public static final List<String> recentModsDefault = new ArrayList<String>();
        public List<String> recentMods = recentModsDefault;
        public static final double scrollAmountDefault = Double.MIN_VALUE;
        public double scrollAmount = Double.MIN_VALUE;
    }

    public static enum Key {
        CONTROL,
        ALT,
        SHIFT,
        NONE;

    }

    public static enum Mode {
        DISABLED,
        REMEMBER_RECENT,
        REMEMBER_SCROLL;

    }
}

