/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.modlistmemory;

import dev.terminalmc.modlistmemory.config.Config;
import dev.terminalmc.modlistmemory.util.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class ModListMemory {
    public static final String MOD_ID = "modlistmemory";
    public static final String MOD_NAME = "ModListMemory";
    public static final ModLogger LOG = new ModLogger("ModListMemory");
    public static final int BADGE_TEXT = 0xCACACA;
    public static final int PINNED_BADGE_OUTLINE = -5018855;
    public static final int PINNED_BADGE_FILL = -11719157;
    public static final int RECENT_BADGE_OUTLINE = -14835789;
    public static final int RECENT_BADGE_FILL = -15973299;
    public static FormattedCharSequence pinnedBadgeText = Component.literal((String)"I").getVisualOrderText();
    public static FormattedCharSequence recentBadgeText = Component.literal((String)"R").getVisualOrderText();

    public static void init() {
        Config.getAndSave();
        if (!Config.options().persistOnRestart) {
            Config.options().recentMods.clear();
            Config.options().scrollAmount = Double.MIN_VALUE;
        }
    }

    public static void onClientShutdown(Minecraft mc) {
        if (Config.options().persistOnRestart) {
            Config.save();
        }
    }

    public static void onConfigSaved(Config config) {
        pinnedBadgeText = Component.literal((String)config.options.pinnedText).getVisualOrderText();
        recentBadgeText = Component.literal((String)config.options.recentText).getVisualOrderText();
    }

    public static void onModOpened(String modId) {
        if (Config.options().pinnedMods.contains(modId)) {
            return;
        }
        Config.options().recentMods.remove(modId);
        Config.options().recentMods.addLast(modId);
        while (Config.options().recentMods.size() > Config.options().recentModsSize) {
            Config.options().recentMods.removeFirst();
        }
        if (Config.options().persistOnRestart && Config.options().saveOnUpdate) {
            Config.save();
        }
    }

    public static boolean onModClicked(String modId) {
        if (ModListMemory.hasKeyDown(Config.options().pinKey)) {
            Config.options().recentMods.remove(modId);
            Config.options().pinnedMods.remove(modId);
            Config.options().pinnedMods.addLast(modId);
            while (Config.options().pinnedMods.size() > Config.options().pinnedModsSize) {
                Config.options().pinnedMods.removeFirst();
            }
            if (Config.options().persistOnRestart && Config.options().saveOnUpdate) {
                Config.save();
            }
            return true;
        }
        if (ModListMemory.hasKeyDown(Config.options().unpinKey) && Config.options().pinnedMods.contains(modId)) {
            Config.options().pinnedMods.remove(modId);
            if (Config.options().persistOnRestart && Config.options().saveOnUpdate) {
                Config.save();
            }
            return true;
        }
        return false;
    }

    public static boolean hasKeyDown(Config.Key key) {
        return switch (key) {
            default -> throw new MatchException(null, null);
            case Config.Key.CONTROL -> Screen.hasControlDown();
            case Config.Key.ALT -> Screen.hasAltDown();
            case Config.Key.SHIFT -> Screen.hasShiftDown();
            case Config.Key.NONE -> false;
        };
    }
}

