/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.mirouters.item;

import aztech.modern_industrialization.api.energy.CableTier;
import com.matyrobbrt.mirouters.MIRouters;
import java.util.List;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EUUpgrade
extends UpgradeItem {
    public final CableTier tier;
    private final long capacity;
    private final long transfer;
    public static final TintColor TINT_COLOR = new TintColor(79, 20, 60);

    public EUUpgrade(CableTier tier, long capacity, long transfer) {
        this.tier = tier;
        this.capacity = capacity;
        this.transfer = transfer;
    }

    public long getMax(int amountOfUpgrades) {
        return this.capacity * (long)amountOfUpgrades;
    }

    public long getTransferCap(int amountOfUpgrades) {
        return this.transfer * (long)amountOfUpgrades;
    }

    public TintColor getItemTint() {
        return TINT_COLOR;
    }

    public boolean isCompatibleWith(UpgradeItem other) {
        return !(other instanceof EUUpgrade) && other != ModItems.ENERGY_UPGRADE.value();
    }

    protected Object[] getExtraUsageParams() {
        return new Object[]{this.tier.shortEnglishName().withStyle(ChatFormatting.GOLD), this.capacity, this.transfer};
    }

    public void addUsageInformation(ItemStack itemstack, List<Component> list) {
        super.addUsageInformation(itemstack, list);
        ClientUtil.getOpenItemRouter().ifPresent(router -> {
            MIRouters.EnergyStorage storage = (MIRouters.EnergyStorage)router.getData(MIRouters.STORAGE);
            list.add((Component)Component.translatable((String)"modernindustrialrouters.in_gui.eu_upgrade", (Object[])new Object[]{storage.getCapacity(), storage.getTransferRate()}));
        });
    }

    public int getStackLimit(int slot) {
        return 64;
    }

    public void processClientSync(ModularRouterBlockEntity router, @Nullable CompoundTag tag) {
        ((MIRouters.EnergyStorage)router.getData(MIRouters.STORAGE)).update();
        router.getLevel().invalidateCapabilities(router.getBlockPos());
    }
}

