/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.mirouters.client;

import java.util.function.BooleanSupplier;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EUWidget
extends AbstractWidget {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.parse((String)"modern_industrialization:textures/gui/container/slot_atlas.png");
    private final IEnergyStorage storage;
    private final BooleanSupplier render;

    public EUWidget(IEnergyStorage storage, int pX, int pY, BooleanSupplier render) {
        super(pX, pY, 13, 18, (Component)Component.empty());
        this.storage = storage;
        this.render = render;
    }

    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.render.getAsBoolean()) {
            int amount = this.getScaled();
            graphics.blit(TEXTURE_LOCATION, this.getX(), this.getY(), 230.0f, 0.0f, this.width, this.height, 256, 256);
            graphics.blit(TEXTURE_LOCATION, this.getX(), this.getY() + 18 - amount, 243.0f, (float)(18 - amount), this.width, amount, 256, 256);
            if (this.isHovered()) {
                MutableComponent text = Component.literal((String)(MiscUtil.commify((int)this.storage.getEnergyStored()) + " / " + MiscUtil.commify((int)this.storage.getMaxEnergyStored()) + " EU"));
                graphics.renderTooltip(Minecraft.getInstance().font, (Component)text, pMouseX, pMouseY);
            }
        }
    }

    private int getScaled() {
        return this.storage.getMaxEnergyStored() <= 0 ? this.height : (int)((long)this.storage.getEnergyStored() * (long)this.height / (long)this.storage.getMaxEnergyStored());
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

