/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.mirouters;

import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import com.matyrobbrt.mirouters.MIRouters;
import dev.technici4n.grandpower.api.EnergyStorageUtil;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.List;
import me.desht.modularrouters.api.event.AddModuleTargetEvent;
import me.desht.modularrouters.api.event.ExecuteModuleEvent;
import me.desht.modularrouters.api.event.RegisterRouterContainerData;
import me.desht.modularrouters.api.event.RouterCompiledEvent;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.util.BeamData;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.DataSlot;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.BlockCapability;

public class ModuleCustomiser {
    @SubscribeEvent
    static void onModule(ExecuteModuleEvent event) {
        MIRouters.EnergyStorage routerStorage;
        if (event.getModule().getModule() == ModItems.ENERGY_OUTPUT_MODULE.value()) {
            MIRouters.EnergyStorage routerStorage2 = (MIRouters.EnergyStorage)event.getRouter().getData(MIRouters.STORAGE);
            if (event.getModule().getTarget() != null && routerStorage2.getCapacity() > 0L && routerStorage2.getTier() != null) {
                MIEnergyStorage otherStorage = (MIEnergyStorage)ModuleCustomiser.getCapability(event.getModule().getTarget(), EnergyApi.SIDED);
                if (otherStorage != null && otherStorage.canConnect(routerStorage2.getTier())) {
                    event.setExecuted(EnergyStorageUtil.move((ILongEnergyStorage)routerStorage2, (ILongEnergyStorage)otherStorage, (long)routerStorage2.getTransferRate()) > 0L);
                }
                event.setCanceled(true);
            }
        } else if (event.getModule().getModule() == ModItems.ENERGY_DISTRIBUTOR_MODULE.value() && (routerStorage = (MIRouters.EnergyStorage)event.getRouter().getData(MIRouters.STORAGE)).getCapacity() > 0L && routerStorage.getTier() != null) {
            List<ModuleTarget> inRange = event.getModule().getTargets().stream().filter(targetx -> targetx.isSameWorld(event.getRouter().getLevel()) && event.getRouter().getBlockPos().distSqr((Vec3i)targetx.gPos.pos()) <= (double)event.getModule().getRangeSquared()).toList();
            if (!inRange.isEmpty()) {
                long toSend = routerStorage.getAmount() / (long)inRange.size();
                boolean doBeam = event.getRouter().getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get()) < 2;
                long total = 0L;
                for (ModuleTarget target : inRange) {
                    MIEnergyStorage otherStorage = (MIEnergyStorage)ModuleCustomiser.getCapability(target, EnergyApi.SIDED);
                    if (otherStorage == null || !otherStorage.canConnect(routerStorage.getTier())) continue;
                    long sent = EnergyStorageUtil.move((ILongEnergyStorage)routerStorage, (ILongEnergyStorage)otherStorage, (long)toSend);
                    if (sent > 0L && doBeam) {
                        event.getRouter().addItemBeam(new BeamData.Builder(event.getRouter(), target.gPos.pos(), 0xE04040).build());
                    }
                    total += sent;
                }
                event.setExecuted(total > 0L);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void checkValidTarget(AddModuleTargetEvent event) {
        if (event.getModuleType() == ModItems.ENERGY_DISTRIBUTOR_MODULE.value() && !event.isValid() && event.getContext().getLevel().getCapability(EnergyApi.SIDED, event.getContext().getClickedPos(), (Object)event.getContext().getClickedFace()) != null) {
            event.setValid(true);
        }
    }

    @SubscribeEvent
    static void onCompileUpgrades(RouterCompiledEvent.Upgrades event) {
        ((MIRouters.EnergyStorage)event.getRouter().getData(MIRouters.STORAGE)).update();
    }

    @SubscribeEvent
    static void registerMenu(RegisterRouterContainerData event) {
        final ModularRouterBlockEntity router = event.getRouter();
        event.register(ResourceLocation.fromNamespaceAndPath((String)"modernindustrialrouters", (String)"eu"), new DataSlot(){

            public int get() {
                return (int)((MIRouters.EnergyStorage)router.getData(MIRouters.STORAGE)).getAmount();
            }

            public void set(int pValue) {
                ((MIRouters.EnergyStorage)router.getData(MIRouters.STORAGE)).stored = pValue;
            }
        });
    }

    private static <T, C> T getCapability(ModuleTarget target, BlockCapability<T, Direction> cap) {
        return target.getCapability(cap).orElse(null);
    }
}

