/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.mirouters;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import com.matyrobbrt.mirouters.ModuleCustomiser;
import com.matyrobbrt.mirouters.client.ClientMIRouters;
import com.matyrobbrt.mirouters.item.EUUpgrade;
import java.util.List;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="modernindustrialrouters")
public class MIRouters {
    public static final String MOD_ID = "modernindustrialrouters";
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"modernindustrialrouters");
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENTS = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"modernindustrialrouters");
    public static final DeferredItem<EUUpgrade> LV = ITEMS.register("lv_upgrade", () -> new EUUpgrade(CableTier.LV, 1280L, 64L));
    public static final DeferredItem<EUUpgrade> MV = ITEMS.register("mv_upgrade", () -> new EUUpgrade(CableTier.MV, 5120L, 8192L));
    public static final DeferredItem<EUUpgrade> HV = ITEMS.register("hv_upgrade", () -> new EUUpgrade(CableTier.HV, 40960L, 32768L));
    public static final DeferredItem<EUUpgrade> EV = ITEMS.register("ev_upgrade", () -> new EUUpgrade(CableTier.EV, 327680L, 131072L));
    public static final DeferredItem<EUUpgrade> SUPERCONDUCTOR = ITEMS.register("superconductor_upgrade", () -> new EUUpgrade(CableTier.SUPERCONDUCTOR, 0x500000L, 0x3200000L));
    public static final List<DeferredItem<EUUpgrade>> UPGRADES = List.of(LV, MV, HV, EV, SUPERCONDUCTOR);
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<EnergyStorage>> STORAGE = ATTACHMENTS.register("eu_energy", () -> AttachmentType.builder(holder -> new EnergyStorage((ModularRouterBlockEntity)holder)).serialize((IAttachmentSerializer)new IAttachmentSerializer<Tag, EnergyStorage>(){

        public Tag write(EnergyStorage attachment, HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putLong("energy", attachment.getAmount());
            CableTier tier = attachment.getTier();
            if (tier != null) {
                tag.putString("tier", tier.name);
            }
            return tag;
        }

        public EnergyStorage read(IAttachmentHolder holder, Tag tag, HolderLookup.Provider provider) {
            EnergyStorage storage = new EnergyStorage((ModularRouterBlockEntity)holder);
            CompoundTag ctag = (CompoundTag)tag;
            storage.stored = ctag.getLong("energy");
            if (ctag.contains("tier")) {
                storage.tier = CableTier.getTier((String)ctag.getString("tier"));
            }
            return storage;
        }
    }).build());

    public MIRouters(IEventBus bus, Dist dist) {
        ITEMS.register(bus);
        ATTACHMENTS.register(bus);
        if (dist.isClient()) {
            ClientMIRouters.setup(bus);
        }
        bus.addListener(event -> event.registerBlockEntity(EnergyApi.SIDED, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get(), (be, $) -> (MIEnergyStorage)be.getData(STORAGE)));
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.parse((String)"modularrouters:default"));
        bus.addListener(event -> {
            if (event.getTabKey() == key) {
                UPGRADES.forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
            }
        });
        bus.addListener(event -> {
            event.getGenerator().addProvider(event.includeClient(), (DataProvider)new LanguageProvider(this, event.getGenerator().getPackOutput(), MOD_ID, "en_us"){

                protected void addTranslations() {
                    this.add((Item)LV.value(), "LV Energy Upgrade");
                    this.add((Item)HV.value(), "HV Energy Upgrade");
                    this.add((Item)MV.value(), "MV Energy Upgrade");
                    this.add((Item)EV.value(), "EV Energy Upgrade");
                    this.add((Item)SUPERCONDUCTOR.value(), "Superconductor Energy Upgrade");
                    UPGRADES.forEach(up -> this.add(this.make((ItemLike)up), "Makes energy modules in a router behave as if they are transferring Modern Industrialisation EU of tier %d\nIncreases a router's energy buffer capacity by %d EU and transfer rate by %d EU/router tick"));
                    this.add("modernindustrialrouters.in_gui.eu_upgrade", "\u2022 This router's energy capacity: %d EU\n\u2022 This router's transfer rate: %d EU/router tick");
                }

                private String make(ItemLike itemLike) {
                    return "modularrouters.itemText.usage.item." + BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem()).getPath();
                }
            });
            event.getGenerator().addProvider(event.includeServer(), (DataProvider)new RecipeProvider(this, event.getGenerator().getPackOutput(), event.getLookupProvider()){

                protected void buildRecipes(RecipeOutput output) {
                    ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, LV).pattern("CCC").pattern(" U ").pattern("CCC").define(Character.valueOf('C'), (ItemLike)this.miItem("tin_cable")).define(Character.valueOf('U'), (ItemLike)ModItems.ENERGY_UPGRADE).unlockedBy("has_item", 3.has((ItemLike)ModItems.ENERGY_UPGRADE)).save(output);
                    ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, MV).pattern("CCC").pattern(" U ").pattern("CCC").define(Character.valueOf('C'), (ItemLike)this.miItem("electrum_cable")).define(Character.valueOf('U'), (ItemLike)ModItems.ENERGY_UPGRADE).unlockedBy("has_item", 3.has((ItemLike)ModItems.ENERGY_UPGRADE)).save(output);
                    ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, HV).pattern("CCC").pattern(" U ").pattern("CCC").define(Character.valueOf('C'), (ItemLike)this.miItem("aluminum_cable")).define(Character.valueOf('U'), (ItemLike)ModItems.ENERGY_UPGRADE).unlockedBy("has_item", 3.has((ItemLike)ModItems.ENERGY_UPGRADE)).save(output);
                    ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, EV).pattern("CCC").pattern(" U ").pattern("CCC").define(Character.valueOf('C'), (ItemLike)this.miItem("annealed_copper_cable")).define(Character.valueOf('U'), (ItemLike)ModItems.ENERGY_UPGRADE).unlockedBy("has_item", 3.has((ItemLike)ModItems.ENERGY_UPGRADE)).save(output);
                    ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SUPERCONDUCTOR).pattern("CCC").pattern(" U ").pattern("CCC").define(Character.valueOf('C'), (ItemLike)this.miItem("superconductor_cable")).define(Character.valueOf('U'), (ItemLike)ModItems.ENERGY_UPGRADE).unlockedBy("has_item", 3.has((ItemLike)ModItems.ENERGY_UPGRADE)).save(output);
                }

                private Item miItem(String name) {
                    return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"modern_industrialization", (String)name));
                }
            });
        });
        NeoForge.EVENT_BUS.register(ModuleCustomiser.class);
    }

    public static class EnergyStorage
    implements MIEnergyStorage {
        private final ModularRouterBlockEntity be;
        public long stored;
        private long max;
        private long transferMax;
        private CableTier tier = null;

        public EnergyStorage(ModularRouterBlockEntity be) {
            this.be = be;
        }

        public CableTier getTier() {
            return this.tier;
        }

        public long getTransferRate() {
            return this.transferMax;
        }

        public void update() {
            long oldMax = this.max;
            CableTier oldTier = this.tier;
            UPGRADES.stream().filter(eu -> this.be.getUpgradeCount((UpgradeItem)eu.value()) > 0).findFirst().map(DeferredHolder::value).ifPresentOrElse(up -> {
                this.tier = up.tier;
                this.max = up.getMax(this.be.getUpgradeCount((UpgradeItem)up));
                this.transferMax = up.getTransferCap(this.be.getUpgradeCount((UpgradeItem)up));
                if (this.stored > this.max) {
                    this.stored = this.max;
                    this.be.setChanged();
                }
            }, () -> {
                this.tier = null;
                this.stored = 0L;
                this.max = 0L;
                this.transferMax = 0L;
                this.be.setChanged();
            });
            if (oldMax == 0L && this.max > 0L || oldTier != this.tier) {
                this.be.invalidateCapabilities();
                this.be.getLevel().updateNeighborsAt(this.be.getBlockPos(), this.be.getBlockState().getBlock());
            }
        }

        public boolean canConnect(CableTier cableTier) {
            return this.tier == null || this.tier == cableTier;
        }

        public long receive(long maxReceive, boolean simulate) {
            if (this.max == 0L) {
                return this.be.getEnergyStorage().receiveEnergy((int)Math.min(maxReceive, Integer.MAX_VALUE), simulate);
            }
            long amount = Math.min(maxReceive, Math.min(this.max - this.stored, this.transferMax));
            if (amount < 0L) {
                return 0L;
            }
            if (!simulate) {
                this.stored += amount;
                this.be.setChanged();
            }
            return amount;
        }

        public long extract(long maxExtract, boolean simulate) {
            long amount = Math.min(maxExtract, Math.min(this.stored, this.transferMax));
            if (amount < 0L) {
                return 0L;
            }
            if (!simulate) {
                this.stored -= amount;
                this.be.setChanged();
            }
            return amount;
        }

        public long getAmount() {
            return this.max == 0L ? (long)this.be.getEnergyStorage().getEnergyStored() : this.stored;
        }

        public long getCapacity() {
            return this.max == 0L ? (long)this.be.getEnergyStorage().getMaxEnergyStored() : this.max;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

