/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.recipe.EmptyInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BeheadingRecipe
implements Recipe<EmptyInput> {
    public static final String NAME = "beheading";
    private final EntityType<?> entityType;
    private final ItemStack result;

    public BeheadingRecipe(EntityType<?> type, ItemStack output) {
        this.entityType = type;
        this.result = output;
    }

    public boolean matches(@Nonnull EmptyInput container, @Nonnull Level level) {
        return false;
    }

    public boolean matches(EntityType<?> typeIn) {
        return typeIn == this.entityType;
    }

    @Nonnull
    public ItemStack assemble(EmptyInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MobGrindingUtils.BEHEADING_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)MobGrindingUtils.BEHEADING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BeheadingRecipe> {
        public static final MapCodec<BeheadingRecipe> CODEC = RecordCodecBuilder.mapCodec(p_300958_ -> p_300958_.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(p_300960_ -> p_300960_.entityType), (App)ItemStack.CODEC.fieldOf("result").forGetter(p_300962_ -> p_300962_.result)).apply((Applicative)p_300958_, BeheadingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BeheadingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nonnull
        public static BeheadingRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            ResourceLocation entityRes = ResourceLocation.parse((String)buf.readUtf());
            Optional type = BuiltInRegistries.ENTITY_TYPE.getOptional(entityRes);
            if (type.isEmpty()) {
                throw new JsonParseException("unknown entity type");
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            return new BeheadingRecipe((EntityType)type.get(), result);
        }

        public MapCodec<BeheadingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BeheadingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, BeheadingRecipe recipe) {
            buf.writeUtf(BuiltInRegistries.ENTITY_TYPE.getKey(recipe.entityType).toString());
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
        }
    }
}

