/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.minecoloniesbluemap.util;

import com.google.common.html.HtmlEscapers;
import com.ldtteam.minecoloniesbluemap.util.FileLoader;
import com.ldtteam.minecoloniesbluemap.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class HtmlParser {
    private static final String CHILD_FORMAT = "\\{\\-%s\\-\\}";
    private static final String VARIABLE_FORMAT = "\\{\\{%s\\}\\}";

    private HtmlParser() {
    }

    public static HttpContent parseHtml(@NotNull ResourceLocation file, @NotNull HttpParsingContext context) {
        Optional<InputStream> resource = FileLoader.openFile(file);
        if (resource.isPresent()) {
            try {
                String htmlString = IOUtils.toString((InputStream)resource.get(), (Charset)Charset.defaultCharset());
                return HtmlParser.parseHtml(htmlString, context);
            }
            catch (IOException ex) {
                Log.getLogger().error("Failure opening resource file for HTML parsing", (Throwable)ex);
            }
        }
        return new HttpContent("", Map.of());
    }

    public static HttpContent parseHtml(@NotNull String content, @NotNull HttpParsingContext context) {
        try {
            String htmlString = content;
            for (Map.Entry<String, Collection<HttpContent>> entry : context.children.entrySet()) {
                String childrenHtml = entry.getValue().stream().map(HttpContent::build).collect(Collectors.joining());
                htmlString = htmlString.replaceAll(CHILD_FORMAT.formatted(entry.getKey()), childrenHtml);
            }
            return new HttpContent(htmlString, context.variables);
        }
        catch (Exception ex) {
            Log.getLogger().error("Failure parsing HTML file", (Throwable)ex);
            return new HttpContent("", Map.of());
        }
    }

    public static class HttpParsingContext {
        private final Map<String, Collection<HttpContent>> children = new HashMap<String, Collection<HttpContent>>();
        private final Map<String, String> variables = new HashMap<String, String>();

        private HttpParsingContext() {
        }

        public static HttpParsingContext builder() {
            return new HttpParsingContext();
        }

        public HttpParsingContext withVariable(String key, String value) {
            this.variables.put(key, value);
            return this;
        }

        public HttpParsingContext withChild(String key, HttpContent value) {
            this.children.put(key, List.of(value));
            return this;
        }

        public HttpParsingContext withChildren(String key, Collection<HttpContent> values) {
            this.children.put(key, values);
            return this;
        }
    }

    public static class HttpContent {
        private final String rawContent;
        private final Map<String, String> variables;

        private HttpContent(String rawContent, Map<String, String> variables) {
            this.rawContent = rawContent;
            this.variables = variables;
        }

        public String build() {
            String htmlString = this.rawContent;
            for (Map.Entry<String, String> entry : this.variables.entrySet()) {
                htmlString = htmlString.replaceAll(HtmlParser.VARIABLE_FORMAT.formatted(entry.getKey()), HtmlEscapers.htmlEscaper().escape(entry.getValue()));
            }
            return htmlString;
        }
    }
}

