/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.minecoloniesbluemap.integration.markers;

import com.ldtteam.minecoloniesbluemap.area.AreaGenerator;
import com.ldtteam.minecoloniesbluemap.area.ColonyArea;
import com.ldtteam.minecoloniesbluemap.area.ColonyChunkClaimCalculator;
import com.ldtteam.minecoloniesbluemap.util.HtmlParser;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;

public class ColonyMarker {
    private static final ResourceLocation TEMPLATE_MARKER_COLONY = ResourceLocation.fromNamespaceAndPath((String)"minecoloniesbluemap", (String)"markers/colony.html");
    private static final ResourceLocation TEMPLATE_MARKER_COLONY_BUILDING_ROW = ResourceLocation.fromNamespaceAndPath((String)"minecoloniesbluemap", (String)"markers/building_row.html");
    private static final ResourceLocation TEMPLATE_MARKER_COLONY_CITIZEN_EMPLOYED_ROW = ResourceLocation.fromNamespaceAndPath((String)"minecoloniesbluemap", (String)"markers/citizen_employed_row.html");
    private static final ResourceLocation TEMPLATE_MARKER_COLONY_CITIZEN_UNEMPLOYED_ROW = ResourceLocation.fromNamespaceAndPath((String)"minecoloniesbluemap", (String)"markers/citizen_unemployed_row.html");
    private static final float COLONY_MARKER_LINE_COLOR_ALPHA = 1.0f;
    private static final float COLONY_MARKER_FILL_COLOR_ALPHA = 0.3f;

    private ColonyMarker() {
    }

    public static String createDetails(IColony colony) {
        Map<BuildingEntry, Long> buildingsData = colony.getBuildingManager().getBuildings().values().stream().collect(Collectors.groupingBy(IBuilding::getBuildingType, Collectors.counting()));
        ArrayList<HtmlParser.HttpContent> buildingInfo = new ArrayList<HtmlParser.HttpContent>();
        for (Map.Entry<BuildingEntry, Long> entry : buildingsData.entrySet()) {
            HtmlParser.HttpParsingContext buildingMarkerContext = HtmlParser.HttpParsingContext.builder().withVariable("building_type", Component.translatable((String)entry.getKey().getTranslationKey()).getString()).withVariable("count", String.valueOf(entry.getValue()));
            buildingInfo.add(HtmlParser.parseHtml(TEMPLATE_MARKER_COLONY_BUILDING_ROW, buildingMarkerContext));
        }
        ArrayList<HtmlParser.HttpContent> citizenInfo = new ArrayList<HtmlParser.HttpContent>();
        for (ICitizenData citizen : colony.getCitizenManager().getCitizens()) {
            HtmlParser.HttpParsingContext citizenMarkerContext = HtmlParser.HttpParsingContext.builder().withVariable("name", citizen.getName());
            Optional<String> jobText = Optional.ofNullable(citizen.getJob()).map(IJob::getJobRegistryEntry).map(JobEntry::getTranslationKey).map(Component::translatable).map(Component::getString);
            if (jobText.isPresent()) {
                citizenMarkerContext.withVariable("job", jobText.get());
                citizenInfo.add(HtmlParser.parseHtml(TEMPLATE_MARKER_COLONY_CITIZEN_EMPLOYED_ROW, citizenMarkerContext));
                continue;
            }
            citizenInfo.add(HtmlParser.parseHtml(TEMPLATE_MARKER_COLONY_CITIZEN_UNEMPLOYED_ROW, citizenMarkerContext));
        }
        HtmlParser.HttpParsingContext httpParsingContext = HtmlParser.HttpParsingContext.builder().withVariable("icon", ColonyMarker.getColonyIcon(colony)).withVariable("colony", colony.getName()).withVariable("mayor", colony.getPermissions().getOwnerName()).withVariable("style", colony.getStructurePack()).withVariable("building_count", String.valueOf(colony.getBuildingManager().getBuildings().size())).withVariable("citizen_count", String.valueOf(colony.getCitizenManager().getCitizens().size())).withChildren("building_info", buildingInfo).withChildren("citizen_info", citizenInfo);
        return HtmlParser.parseHtml(TEMPLATE_MARKER_COLONY, httpParsingContext).build();
    }

    private static String getColonyIcon(IColony colony) {
        int currentCitizens = colony.getCitizenManager().getCitizens().size();
        String icon = "outpost";
        if (currentCitizens >= 150) {
            icon = "city";
        } else if (currentCitizens >= 100) {
            icon = "village";
        } else if (currentCitizens >= 50) {
            icon = "hamlet";
        }
        return icon;
    }

    public static Shape createShape(IColony colony) {
        Collection<ChunkPos> claimedChunks = ColonyChunkClaimCalculator.getAllClaimedChunks(colony);
        ColonyArea area = AreaGenerator.generateAreaFromChunks(claimedChunks);
        return Shape.builder().addPoints(area.getPoints()).build();
    }

    public static Color getLineColor(IColony colony) {
        Color baseColor = new Color(Optional.ofNullable(colony.getTeamColonyColor()).map(ChatFormatting::getColor).orElse(0).intValue());
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), 1.0f);
    }

    public static Color getFillColor(IColony colony) {
        Color baseColor = new Color(Optional.ofNullable(colony.getTeamColonyColor()).map(ChatFormatting::getColor).orElse(0).intValue());
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), 0.3f);
    }
}

