/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.minecoloniesbluemap.integration;

import com.ldtteam.minecoloniesbluemap.integration.BlueMapAssetManager;
import com.ldtteam.minecoloniesbluemap.integration.markers.ColonyMarker;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.eventbus.events.colony.ColonyCreatedModEvent;
import com.minecolonies.api.eventbus.events.colony.ColonyDeletedModEvent;
import com.minecolonies.api.eventbus.events.colony.ColonyNameChangedModEvent;
import com.minecolonies.api.eventbus.events.colony.ColonyTeamColorChangedModEvent;
import com.minecolonies.api.eventbus.events.colony.buildings.BuildingAddedModEvent;
import com.minecolonies.api.eventbus.events.colony.buildings.BuildingConstructionModEvent;
import com.minecolonies.api.eventbus.events.colony.buildings.BuildingRemovedModEvent;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenAddedModEvent;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenDiedModEvent;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenJobChangedModEvent;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluemapIntegration {
    public static final ResourceLocation COLONIES_MARKER_SET = ResourceLocation.fromNamespaceAndPath((String)"minecoloniesbluemap", (String)"colonies");
    public static final ResourceLocation BUILDINGS_MARKER_SET = ResourceLocation.fromNamespaceAndPath((String)"minecoloniesbluemap", (String)"buildings");
    public static final ResourceLocation CITIZENS_MARKER_SET = ResourceLocation.fromNamespaceAndPath((String)"minecoloniesbluemap", (String)"citizens");
    private static final String COLONIES_MARKER_SET_NAME = "MineColonies: Colonies";
    private static final String BUILDINGS_MARKER_SET_NAME = "MineColonies: Buildings";
    private static final String CITIZENS_MARKER_SET_NAME = "MineColonies: Citizens";
    private static final int COLONY_MARKER_MAX_DISTANCE = 5000;
    @Nullable
    private BlueMapAPI api;

    public void onEnable(BlueMapAPI api) {
        this.api = api;
        BlueMapAssetManager.createAssets(api);
        this.ensureMarkerSetsExist();
        IMinecoloniesAPI.getInstance().getColonyManager().getAllColonies().forEach(colony -> this.createColonyMarker((IColony)colony));
    }

    private void ensureMarkerSetsExist() {
        if (this.api == null) {
            return;
        }
        this.api.getMaps().forEach(bMap -> {
            bMap.getMarkerSets().computeIfAbsent(COLONIES_MARKER_SET.toString(), k -> MarkerSet.builder().label(COLONIES_MARKER_SET_NAME).toggleable(Boolean.valueOf(true)).build());
            bMap.getMarkerSets().computeIfAbsent(BUILDINGS_MARKER_SET.toString(), k -> MarkerSet.builder().label(BUILDINGS_MARKER_SET_NAME).toggleable(Boolean.valueOf(true)).defaultHidden(Boolean.valueOf(true)).build());
            bMap.getMarkerSets().computeIfAbsent(CITIZENS_MARKER_SET.toString(), k -> MarkerSet.builder().label(CITIZENS_MARKER_SET_NAME).toggleable(Boolean.valueOf(true)).defaultHidden(Boolean.valueOf(true)).build());
        });
    }

    private void createColonyMarker(IColony colony) {
        ExtrudeMarker marker = ((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)ExtrudeMarker.builder().label(colony.getName())).detail(ColonyMarker.createDetails(colony))).shape(ColonyMarker.createShape(colony), (float)colony.getCenter().getY() - 64.0f, (float)colony.getCenter().getY() + 64.0f).lineColor(ColonyMarker.getLineColor(colony)).fillColor(ColonyMarker.getFillColor(colony)).maxDistance(5000.0)).build();
        this.executeForEachMap(colony, bMap -> ((MarkerSet)bMap.getMarkerSets().get(COLONIES_MARKER_SET.toString())).put(String.valueOf(colony.getID()), (Marker)marker));
    }

    private void executeForEachMap(IColony colony, Consumer<BlueMapMap> action) {
        if (this.api == null) {
            return;
        }
        this.ensureMarkerSetsExist();
        this.api.getWorld((Object)colony.getWorld()).ifPresent(bWorld -> bWorld.getMaps().forEach(action));
    }

    public void onDisable(BlueMapAPI api) {
        api.getMaps().forEach(bMap -> {
            bMap.getMarkerSets().remove(COLONIES_MARKER_SET.toString());
            bMap.getMarkerSets().remove(BUILDINGS_MARKER_SET.toString());
            bMap.getMarkerSets().remove(CITIZENS_MARKER_SET.toString());
        });
        this.api = null;
    }

    public void onColonyCreated(@NotNull ColonyCreatedModEvent event) {
        this.createColonyMarker(event.getColony());
    }

    public void onColonyDeleted(@NotNull ColonyDeletedModEvent event) {
        this.executeForEachMap(event.getColony(), bMap -> ((MarkerSet)bMap.getMarkerSets().get(COLONIES_MARKER_SET.toString())).remove(String.valueOf(event.getColony().getID())));
    }

    public void onColonyNameChanged(@NotNull ColonyNameChangedModEvent event) {
        this.executeForEachMap(event.getColony(), bMap -> {
            ExtrudeMarker marker = (ExtrudeMarker)((MarkerSet)bMap.getMarkerSets().get(COLONIES_MARKER_SET.toString())).get(String.valueOf(event.getColony().getID()));
            marker.setLabel(event.getColony().getName());
            marker.setDetail(ColonyMarker.createDetails(event.getColony()));
        });
    }

    public void onColonyTeamColorChanged(@NotNull ColonyTeamColorChangedModEvent event) {
        this.executeForEachMap(event.getColony(), bMap -> {
            ExtrudeMarker marker = (ExtrudeMarker)((MarkerSet)bMap.getMarkerSets().get(COLONIES_MARKER_SET.toString())).get(String.valueOf(event.getColony().getID()));
            marker.setLineColor(ColonyMarker.getLineColor(event.getColony()));
            marker.setFillColor(ColonyMarker.getFillColor(event.getColony()));
        });
    }

    public void onBuildingAdded(@NotNull BuildingAddedModEvent event) {
        this.executeForEachMap(event.getColony(), bMap -> {
            ExtrudeMarker marker = (ExtrudeMarker)((MarkerSet)bMap.getMarkerSets().get(COLONIES_MARKER_SET.toString())).get(String.valueOf(event.getColony().getID()));
            marker.setDetail(ColonyMarker.createDetails(event.getColony()));
        });
    }

    public void onBuildingConstruction(@NotNull BuildingConstructionModEvent event) {
        this.executeForEachMap(event.getColony(), bMap -> {
            ExtrudeMarker marker = (ExtrudeMarker)((MarkerSet)bMap.getMarkerSets().get(COLONIES_MARKER_SET.toString())).get(String.valueOf(event.getColony().getID()));
            marker.setDetail(ColonyMarker.createDetails(event.getColony()));
        });
    }

    public void onBuildingRemoved(@NotNull BuildingRemovedModEvent event) {
        this.executeForEachMap(event.getColony(), bMap -> {
            ExtrudeMarker marker = (ExtrudeMarker)((MarkerSet)bMap.getMarkerSets().get(COLONIES_MARKER_SET.toString())).get(String.valueOf(event.getColony().getID()));
            marker.setDetail(ColonyMarker.createDetails(event.getColony()));
        });
    }

    public void onCitizenAdded(@NotNull CitizenAddedModEvent event) {
        this.executeForEachMap(event.getColony(), bMap -> {
            ExtrudeMarker marker = (ExtrudeMarker)((MarkerSet)bMap.getMarkerSets().get(COLONIES_MARKER_SET.toString())).get(String.valueOf(event.getColony().getID()));
            marker.setDetail(ColonyMarker.createDetails(event.getColony()));
        });
    }

    public void onCitizenJobChanged(@NotNull CitizenJobChangedModEvent event) {
        this.executeForEachMap(event.getColony(), bMap -> {
            ExtrudeMarker marker = (ExtrudeMarker)((MarkerSet)bMap.getMarkerSets().get(COLONIES_MARKER_SET.toString())).get(String.valueOf(event.getColony().getID()));
            marker.setDetail(ColonyMarker.createDetails(event.getColony()));
        });
    }

    public void onCitizenDied(@NotNull CitizenDiedModEvent event) {
        this.executeForEachMap(event.getColony(), bMap -> {
            ExtrudeMarker marker = (ExtrudeMarker)((MarkerSet)bMap.getMarkerSets().get(COLONIES_MARKER_SET.toString())).get(String.valueOf(event.getColony().getID()));
            marker.setDetail(ColonyMarker.createDetails(event.getColony()));
        });
    }
}

