/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.minecoloniesbluemap.integration;

import com.ldtteam.minecoloniesbluemap.util.FileLoader;
import com.ldtteam.minecoloniesbluemap.util.Log;
import de.bluecolored.bluemap.api.BlueMapAPI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class BlueMapAssetManager {
    private static final String CSS_MINECOLONIES = "css/minecolonies.css";
    private static final String SCRIPTS_MINECOLONIES = "scripts/minecolonies.js";
    private static final String TEXTURE_ARROW = "textures/arrow.svg";
    private static final String TEXTURE_COLONY_CITY = "textures/colony_city.png";
    private static final String TEXTURE_COLONY_VILLAGE = "textures/colony_village.png";
    private static final String TEXTURE_COLONY_HAMLET = "textures/colony_hamlet.png";
    private static final String TEXTURE_COLONY_OUTPOST = "textures/colony_outpost.png";

    private BlueMapAssetManager() {
    }

    public static void createAssets(@NotNull BlueMapAPI api) {
        try {
            Log.getLogger().info("[Bluemap] Clearing old files");
            Path rootPath = api.getWebApp().getWebRoot().resolve(Path.of("assets", "minecolonies"));
            if (Files.exists(rootPath, new LinkOption[0])) {
                try (Stream<Path> walk = Files.walk(rootPath, new FileVisitOption[0]);){
                    walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
            }
            Files.createDirectories(rootPath, new FileAttribute[0]);
            Log.getLogger().info("[Bluemap] Uploading new assets");
            BlueMapAssetManager.copyFile(CSS_MINECOLONIES, rootPath);
            BlueMapAssetManager.copyFile(SCRIPTS_MINECOLONIES, rootPath);
            BlueMapAssetManager.copyFile(TEXTURE_ARROW, rootPath);
            BlueMapAssetManager.copyFile(TEXTURE_COLONY_CITY, rootPath);
            BlueMapAssetManager.copyFile(TEXTURE_COLONY_VILLAGE, rootPath);
            BlueMapAssetManager.copyFile(TEXTURE_COLONY_HAMLET, rootPath);
            BlueMapAssetManager.copyFile(TEXTURE_COLONY_OUTPOST, rootPath);
            Log.getLogger().info("[Bluemap] Registering styles and scripts");
            api.getWebApp().registerStyle(String.format("assets/%s/%s", "minecolonies", CSS_MINECOLONIES));
            api.getWebApp().registerScript(String.format("assets/%s/%s", "minecolonies", SCRIPTS_MINECOLONIES));
        }
        catch (IOException e) {
            Log.getLogger().error("Exception during uploading of assets", (Throwable)e);
        }
    }

    private static void copyFile(String filePath, Path targetDirectory) throws IOException {
        Optional<InputStream> resource = FileLoader.openFile(String.format("web/%s", filePath));
        if (resource.isPresent()) {
            Path subPath = targetDirectory.resolve(filePath);
            Files.createDirectories(subPath.getParent(), new FileAttribute[0]);
            try (InputStream input = resource.get();
                 OutputStream output = Files.newOutputStream(subPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
        }
    }
}

