/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.minecoloniesbluemap.area;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.configuration.ServerConfiguration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;

public class ColonyChunkClaimCalculator {
    private ColonyChunkClaimCalculator() {
    }

    public static Collection<ChunkPos> getAllClaimedChunks(IColony colony) {
        HashSet<ChunkPos> claimedChunks = new HashSet<ChunkPos>();
        ColonyChunkClaimCalculator.getProtectionArea(colony, claimedChunks);
        colony.getBuildingManager().getBuildings().values().forEach(f -> ColonyChunkClaimCalculator.claimBuilding(f, claimedChunks));
        return claimedChunks;
    }

    private static void getProtectionArea(IColony colony, Set<ChunkPos> claimedChunks) {
        ChunkPos protectionAreaCenterChunk = new ChunkPos(colony.getCenter());
        int protectionAreaRadius = (Integer)((ServerConfiguration)IMinecoloniesAPI.getInstance().getConfig().getServer()).initialColonySize.get();
        for (int i = -protectionAreaRadius; i <= protectionAreaRadius; ++i) {
            for (int j = -protectionAreaRadius; j <= protectionAreaRadius; ++j) {
                claimedChunks.add(new ChunkPos(protectionAreaCenterChunk.x + i, protectionAreaCenterChunk.z + j));
            }
        }
    }

    private static void claimBuilding(IBuilding building, Set<ChunkPos> claimedChunks) {
        ChunkPos buildingCenterChunk = new ChunkPos(building.getPosition());
        claimedChunks.add(buildingCenterChunk);
        Tuple corners = building.getCorners();
        ChunkPos bottomLeft = new ChunkPos((BlockPos)corners.getA());
        ChunkPos topRight = new ChunkPos((BlockPos)corners.getB());
        if (!bottomLeft.equals((Object)topRight)) {
            int chunksHorizontal = (topRight.getMinBlockX() - bottomLeft.getMinBlockX()) / 16 + 1;
            int chunksVertical = (topRight.getMinBlockZ() - bottomLeft.getMinBlockZ()) / 16 + 1;
            for (int i = 0; i < chunksHorizontal; ++i) {
                for (int j = 0; j < chunksVertical; ++j) {
                    claimedChunks.add(new ChunkPos(bottomLeft.x + i, bottomLeft.z + j));
                }
            }
        }
        int radius = building.getClaimRadius(building.getBuildingLevel());
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                claimedChunks.add(new ChunkPos(buildingCenterChunk.x + i, buildingCenterChunk.z + j));
            }
        }
    }
}

