/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.minecoloniesbluemap.area;

import com.flowpowered.math.vector.Vector2d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class ColonyArea {
    private final List<Vector2d> points = new ArrayList<Vector2d>();
    private Vector2d secondLast;
    private Vector2d last;

    public Collection<Vector2d> getPoints() {
        return this.points;
    }

    public void addPoint(double x, double z) {
        Vector2d newPoint = new Vector2d(x, z);
        if (this.last != null && this.secondLast != null && (this.last.getX() == x && this.secondLast.getX() == x || this.last.getY() == z && this.secondLast.getY() == z)) {
            this.points.removeLast();
        }
        this.points.add(newPoint);
        if (this.last != null) {
            this.secondLast = this.last.clone();
        }
        this.last = newPoint;
    }

    public void addHole(@Nonnull ColonyArea hole) {
        double minimumDistance = Double.MAX_VALUE;
        int selectedAreaPointIndex = -1;
        int selectedHolePointIndex = -1;
        int areaPointIndex = 0;
        int holePointIndex = 0;
        for (Vector2d point : this.points) {
            holePointIndex = 0;
            for (Vector2d holePoint : hole.points) {
                double distance = this.distanceSq(point, holePoint);
                if (distance < minimumDistance) {
                    minimumDistance = distance;
                    selectedAreaPointIndex = areaPointIndex;
                    selectedHolePointIndex = holePointIndex;
                }
                ++holePointIndex;
            }
            ++areaPointIndex;
        }
        this.generateHole(hole, selectedAreaPointIndex, selectedHolePointIndex);
    }

    private double distanceSq(Vector2d first, Vector2d second) {
        double px = second.getX() - first.getX();
        double py = second.getY() - first.getY();
        return px * px + py * py;
    }

    private void generateHole(@Nonnull ColonyArea hole, int selectedAreaPointIndex, int selectedHolePointIndex) {
        if (selectedAreaPointIndex >= 0 && selectedHolePointIndex >= 0) {
            ArrayList<Vector2d> newPoints = new ArrayList<Vector2d>();
            int currentPosition = selectedHolePointIndex;
            boolean round = false;
            while (!round) {
                Vector2d point = hole.points.get(currentPosition);
                newPoints.add(point.clone());
                if (++currentPosition >= hole.points.size()) {
                    currentPosition = 0;
                }
                if (currentPosition != selectedHolePointIndex) continue;
                Vector2d initialPoint = hole.points.get(currentPosition);
                newPoints.add(initialPoint.clone());
                round = true;
            }
            Vector2d areaPoint = this.points.get(selectedAreaPointIndex);
            newPoints.add(areaPoint.clone());
            this.points.addAll(selectedAreaPointIndex + 1, newPoints);
        }
    }

    public void close() {
        this.points.add(new Vector2d(this.points.getFirst().getX(), this.points.getFirst().getY()));
    }
}

