/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.minecoloniesbluemap.area;

import com.ldtteam.minecoloniesbluemap.area.ColonyArea;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.level.ChunkPos;

public class AreaGenerator {
    private AreaGenerator() {
    }

    public static ColonyArea generateAreaFromChunks(Collection<ChunkPos> chunks) {
        ArrayList<ColonyArea> holes = new ArrayList<ColonyArea>();
        ColonyArea colonyArea = null;
        Area area = AreaGenerator.createArea(chunks);
        PathIterator iterator = area.getPathIterator(null);
        double[] points = new double[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(points);
            if (type == 0) {
                if (colonyArea != null) {
                    holes.add(colonyArea);
                }
                colonyArea = new ColonyArea();
            }
            if (colonyArea != null && (type == 0 || type == 1)) {
                colonyArea.addPoint(points[0], points[1]);
            }
            iterator.next();
        }
        if (colonyArea == null) {
            throw new IllegalArgumentException("Generator could not create an area, did you pass an empty list of chunks?");
        }
        for (ColonyArea hole : holes) {
            colonyArea.addHole(hole);
        }
        colonyArea.close();
        return colonyArea;
    }

    private static Area createArea(Collection<ChunkPos> chunks) {
        Area area = new Area();
        for (ChunkPos chunkPos : chunks) {
            area.add(new Area(new Rectangle(chunkPos.getMinBlockX(), chunkPos.getMinBlockZ(), 16, 16)));
        }
        return area;
    }
}

