/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.minecoloniesbluemap;

import com.ldtteam.minecoloniesbluemap.integration.BluemapIntegration;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.eventbus.events.colony.ColonyCreatedModEvent;
import com.minecolonies.api.eventbus.events.colony.ColonyDeletedModEvent;
import com.minecolonies.api.eventbus.events.colony.ColonyNameChangedModEvent;
import com.minecolonies.api.eventbus.events.colony.ColonyTeamColorChangedModEvent;
import com.minecolonies.api.eventbus.events.colony.buildings.BuildingAddedModEvent;
import com.minecolonies.api.eventbus.events.colony.buildings.BuildingConstructionModEvent;
import com.minecolonies.api.eventbus.events.colony.buildings.BuildingRemovedModEvent;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenAddedModEvent;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenDiedModEvent;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenJobChangedModEvent;
import de.bluecolored.bluemap.api.BlueMapAPI;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="minecoloniesbluemap")
public class MinecoloniesBluemap {
    private final BluemapIntegration integration = new BluemapIntegration();

    public MinecoloniesBluemap(IEventBus modBus) {
        BlueMapAPI.onEnable(this.integration::onEnable);
        BlueMapAPI.onDisable(this.integration::onDisable);
        modBus.addListener(this::preInit);
    }

    public void preInit(@NotNull FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            IMinecoloniesAPI.getInstance().getEventBus().subscribe(ColonyCreatedModEvent.class, this.integration::onColonyCreated);
            IMinecoloniesAPI.getInstance().getEventBus().subscribe(ColonyDeletedModEvent.class, this.integration::onColonyDeleted);
            IMinecoloniesAPI.getInstance().getEventBus().subscribe(ColonyNameChangedModEvent.class, this.integration::onColonyNameChanged);
            IMinecoloniesAPI.getInstance().getEventBus().subscribe(ColonyTeamColorChangedModEvent.class, this.integration::onColonyTeamColorChanged);
            IMinecoloniesAPI.getInstance().getEventBus().subscribe(BuildingAddedModEvent.class, this.integration::onBuildingAdded);
            IMinecoloniesAPI.getInstance().getEventBus().subscribe(BuildingConstructionModEvent.class, this.integration::onBuildingConstruction);
            IMinecoloniesAPI.getInstance().getEventBus().subscribe(BuildingRemovedModEvent.class, this.integration::onBuildingRemoved);
            IMinecoloniesAPI.getInstance().getEventBus().subscribe(CitizenAddedModEvent.class, this.integration::onCitizenAdded);
            IMinecoloniesAPI.getInstance().getEventBus().subscribe(CitizenJobChangedModEvent.class, this.integration::onCitizenJobChanged);
            IMinecoloniesAPI.getInstance().getEventBus().subscribe(CitizenDiedModEvent.class, this.integration::onCitizenDied);
        });
    }
}

