/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerUtils {
    private ServerUtils() {
    }

    @Nullable
    public static Player getPlayerFromUUID(@NotNull Level world, @NotNull UUID id) {
        for (int i = 0; i < world.players().size(); ++i) {
            if (!id.equals(((Player)world.players().get(i)).getGameProfile().getId())) continue;
            return (Player)world.players().get(i);
        }
        return null;
    }

    @NotNull
    public static List<Player> getPlayersFromUUID(@Nullable Level world, @NotNull Collection<UUID> ids) {
        if (world == null) {
            return Collections.emptyList();
        }
        @NotNull ArrayList<Player> players = new ArrayList<Player>();
        for (Object o : world.players()) {
            Player player;
            if (!(o instanceof Player) || !ids.contains((player = (Player)o).getGameProfile().getId())) continue;
            players.add(player);
            if (players.size() != ids.size()) continue;
            return players;
        }
        return players;
    }

    @NotNull
    public static List<Player> getPlayersFromPermPlayer(@NotNull List<Player> players, @NotNull Level world) {
        @NotNull ArrayList<Player> playerList = new ArrayList<Player>();
        for (Player player : players) {
            playerList.add(ServerUtils.getPlayerFromPermPlayer(player, world));
        }
        return playerList;
    }

    @Nullable
    public static Player getPlayerFromPermPlayer(@NotNull Player player, @NotNull Level world) {
        return ServerUtils.getPlayerFromUUID(player.getUUID(), world);
    }

    @Nullable
    public static Player getPlayerFromUUID(@Nullable UUID uuid, @NotNull Level world) {
        if (uuid == null) {
            return null;
        }
        List allPlayers = world.getServer().getPlayerList().getPlayers();
        for (ServerPlayer player : allPlayers) {
            if (!player.getUUID().equals(uuid)) continue;
            return player;
        }
        return null;
    }
}

