/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.structurize.blocks.schematic.BlockSolidSubstitution;
import com.ldtteam.structurize.blocks.schematic.BlockSubstitution;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.util.DomumOrnamentumUtils;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public class SchemAnalyzerUtil {
    public static int getBlockTier(Block block) {
        if (block == null) {
            return -1;
        }
        if (block.defaultBlockState().is(ModTags.tier6blocks)) {
            return 6;
        }
        if (block.defaultBlockState().is(ModTags.tier5blocks)) {
            return 5;
        }
        if (block.defaultBlockState().is(ModTags.tier4blocks)) {
            return 4;
        }
        if (block.defaultBlockState().is(ModTags.tier3blocks)) {
            return 3;
        }
        if (block.defaultBlockState().is(ModTags.tier2blocks)) {
            return 2;
        }
        if (block.defaultBlockState().is(ModTags.tier1blocks)) {
            return 1;
        }
        return 0;
    }

    public static double getScoreFor(Block block) {
        double score = Math.pow(SchemAnalyzerUtil.getBlockTier(block) + 1, 3.0);
        BlockState state = block.defaultBlockState();
        if (state.is(BlockTags.LOGS)) {
            score = Math.min(27.0, score);
        } else if (state.is(BlockTags.WOODEN_STAIRS) || state.is(BlockTags.WOODEN_BUTTONS) || state.is(BlockTags.WOODEN_DOORS) || state.is(BlockTags.WOODEN_SLABS) || state.is(BlockTags.WOODEN_FENCES) || state.is(BlockTags.WOODEN_TRAPDOORS) || state.is(BlockTags.WOODEN_PRESSURE_PLATES)) {
            score = Math.min(27.0, score);
            score *= 0.25;
        } else if (state.is(BlockTags.PLANKS)) {
            score = Math.min(27.0, score);
            score *= 0.25;
        } else if (state.is(BlockTags.SLABS)) {
            score *= 0.5;
        } else if (state.is(BlockTags.BANNERS)) {
            score *= 6.0;
        } else if (state.is(Tags.Blocks.STORAGE_BLOCKS)) {
            score *= 9.0;
        } else if (state.is(BlockTags.ANVIL)) {
            score *= 31.0;
        } else if (state.is(Tags.Blocks.BOOKSHELVES)) {
            score *= 3.0;
        } else if (state.is(BlockTags.BASE_STONE_NETHER)) {
            score = 8.0;
        }
        return score;
    }

    public static SchematicAnalyzationResult analyzeSchematic(Blueprint blueprint) {
        double complexityScore = 0.0;
        int containedBuildings = 0;
        HashMap<ItemStorage, ItemStorage> blocks = new HashMap<ItemStorage, ItemStorage>();
        for (BlockInfo blockInfo : blueprint.getBlockInfoAsList()) {
            ItemStorage storage;
            if (SchemAnalyzerUtil.isExcludedBlock(blockInfo.getState())) continue;
            Block block = blockInfo.getState().getBlock();
            double blockComplexity = 0.0;
            if (DomumOrnamentumUtils.isDoBlock(block) && blockInfo.hasTileEntityData()) {
                MaterialTextureData textureData = (MaterialTextureData)Utils.deserializeCodecMess(MaterialTextureData.CODEC, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (Tag)blockInfo.getTileEntityData().getCompound("textureData"));
                ItemStack result = new ItemStack((ItemLike)block);
                if (!textureData.isEmpty()) {
                    double doComplexity = 0.0;
                    for (Block doBlockPart : textureData.getTexturedComponents().values()) {
                        doComplexity += SchemAnalyzerUtil.getScoreFor(doBlockPart);
                    }
                    blockComplexity = Math.max(2.0, doComplexity / 3.0);
                    textureData.writeToItemStack(result);
                }
                storage = new ItemStorage(result);
            } else {
                blockComplexity = SchemAnalyzerUtil.getScoreFor(block);
                storage = new ItemStorage(block.asItem().getDefaultInstance());
            }
            complexityScore += blockComplexity;
            storage.setAmount(0);
            storage.getItemStack().setCount((int)Math.max(1.0, blockComplexity));
            ItemStorage contained = (ItemStorage)blocks.get(storage);
            if (contained == null) {
                contained = storage;
                blocks.put(contained, contained);
            }
            contained.setAmount(contained.getAmount() + 1);
            if (!(block instanceof AbstractBlockHut)) continue;
            ++containedBuildings;
        }
        complexityScore += (double)(containedBuildings * 500);
        complexityScore += (double)(blocks.keySet().size() * 40);
        return new SchematicAnalyzationResult((int)(complexityScore += (double)(blueprint.getSizeX() * blueprint.getSizeY() * blueprint.getSizeZ()) / 10.0), blocks.keySet(), containedBuildings, blueprint);
    }

    private static boolean isExcludedBlock(BlockState blockState) {
        return blockState == null || blockState.isAir() || blockState.getBlock() instanceof BlockSubstitution || blockState.getBlock() instanceof BlockSolidSubstitution;
    }

    public static class SchematicAnalyzationResult {
        public final int costScore;
        public final Set<ItemStorage> differentBlocks;
        public final int containedBuildings;
        public final Blueprint blueprint;

        public SchematicAnalyzationResult(int costScore, Set<ItemStorage> differentBlocks, int containedBuildings, Blueprint blueprint) {
            this.costScore = costScore;
            this.differentBlocks = differentBlocks;
            this.containedBuildings = containedBuildings;
            this.blueprint = blueprint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchematicAnalyzationResult that = (SchematicAnalyzationResult)o;
            return Objects.equals(this.blueprint, that.blueprint);
        }

        public int hashCode() {
            return Objects.hash(this.blueprint);
        }
    }
}

