/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public abstract class AttributeModifierUtils {
    public static void removeAllHealthModifiers(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        entity.getAttribute(Attributes.MAX_HEALTH).removeModifiers();
        if (entity.getHealth() > entity.getMaxHealth()) {
            entity.setHealth(entity.getMaxHealth());
        }
    }

    public static void removeHealthModifier(LivingEntity entity, ResourceLocation modifierName) {
        if (entity == null) {
            return;
        }
        entity.getAttribute(Attributes.MAX_HEALTH).removeModifier(modifierName);
        if (entity.getHealth() > entity.getMaxHealth()) {
            entity.setHealth(entity.getMaxHealth());
        }
    }

    public static void addHealthModifier(LivingEntity entity, AttributeModifier modifier) {
        if (entity == null) {
            return;
        }
        float prevHealthPct = entity.getHealth() / entity.getMaxHealth();
        AttributeModifierUtils.removeHealthModifier(entity, modifier.id());
        entity.getAttribute(Attributes.MAX_HEALTH).addTransientModifier(modifier);
        entity.setHealth(entity.getMaxHealth() * prevHealthPct);
    }

    public static void removeModifier(LivingEntity entity, ResourceLocation modifierName, Holder<Attribute> attribute) {
        if (entity == null) {
            return;
        }
        entity.getAttribute(attribute).removeModifier(modifierName);
    }

    public static void addModifier(LivingEntity entity, AttributeModifier modifier, Holder<Attribute> attribute) {
        if (entity == null) {
            return;
        }
        AttributeModifierUtils.removeModifier(entity, modifier.id(), attribute);
        entity.getAttribute(attribute).addTransientModifier(modifier);
    }
}

