/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IResearchEffect;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchEffects;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.factories.IGlobalResearchFactory;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.research.GlobalResearch;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public class GlobalResearchFactory
implements IGlobalResearchFactory {
    @Override
    @NotNull
    public TypeToken<GlobalResearch> getFactoryOutputType() {
        return TypeToken.of(GlobalResearch.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public IGlobalResearch getNewInstance(ResourceLocation id, ResourceLocation parent, ResourceLocation branch, TranslatableContents name, TranslatableContents subtitle, int depth, int sortOrder, boolean onlyChild, boolean hidden, boolean autostart, boolean instant, boolean immutable) {
        return new GlobalResearch(id, parent, branch, name, subtitle, depth, sortOrder, onlyChild, hidden, autostart, instant, immutable);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull IGlobalResearch research) {
        CompoundTag compound = new CompoundTag();
        if (research.getParent() != null) {
            compound.putString("parent", research.getParent().toString());
        }
        compound.putString("id", research.getId().toString());
        compound.putString("branch", research.getBranch().toString());
        compound.putString("name", research.getName().getKey());
        compound.putInt("depth", research.getDepth());
        compound.putInt("sort", research.getSortOrder());
        compound.putBoolean("onlyChild", research.hasOnlyChild());
        compound.putString("subtitle", research.getSubtitle().getKey());
        compound.putBoolean("instant", research.isInstant());
        compound.putBoolean("autostart", research.isAutostart());
        compound.putBoolean("immutable", research.isImmutable());
        compound.putBoolean("hidden", research.isHidden());
        compound.put("cost", Utils.serializeCodecMess(SizedIngredient.FLAT_CODEC.listOf(), provider, research.getCostList()));
        @NotNull ListTag reqTagList = research.getResearchRequirements().stream().map(req -> {
            CompoundTag reqCompound = new CompoundTag();
            reqCompound.putString("requirement-type", req.getRegistryEntry().getRegistryName().toString());
            reqCompound.put("requirement-item", (Tag)req.writeToNBT());
            return reqCompound;
        }).collect(NBTUtils.toListNBT());
        compound.put("requirements", (Tag)reqTagList);
        @NotNull ListTag effectTagList = research.getEffects().stream().map(eff -> {
            CompoundTag effectCompound = new CompoundTag();
            effectCompound.putString("effect-type", eff.getRegistryEntry().getRegistryName().toString());
            effectCompound.put("effect-item", (Tag)eff.writeToNBT());
            return effectCompound;
        }).collect(NBTUtils.toListNBT());
        compound.put("effects", (Tag)effectTagList);
        @NotNull ListTag childTagList = research.getChildren().stream().map(child -> {
            CompoundTag childCompound = new CompoundTag();
            childCompound.putString("child", child.toString());
            return childCompound;
        }).collect(NBTUtils.toListNBT());
        compound.put("hasResearchedChild", (Tag)childTagList);
        return compound;
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        ResourceLocation id = ResourceLocation.parse((String)nbt.getString("id"));
        ResourceLocation parent = nbt.contains("parent") ? ResourceLocation.parse((String)nbt.getString("parent")) : null;
        ResourceLocation branch = ResourceLocation.parse((String)nbt.getString("branch"));
        TranslatableContents name = new TranslatableContents(nbt.getString("name"), null, TranslatableContents.NO_ARGS);
        TranslatableContents subtitle = new TranslatableContents(nbt.getString("subtitle"), null, TranslatableContents.NO_ARGS);
        int depth = nbt.getInt("depth");
        int sortOrder = nbt.getInt("sort");
        boolean onlyChild = nbt.getBoolean("onlyChild");
        boolean instant = nbt.getBoolean("instant");
        boolean autostart = nbt.getBoolean("autostart");
        boolean immutable = nbt.getBoolean("immutable");
        boolean hidden = nbt.getBoolean("hidden");
        IGlobalResearch research = this.getNewInstance(id, parent, branch, name, subtitle, depth, sortOrder, onlyChild, hidden, autostart, instant, immutable);
        ((List)Utils.deserializeCodecMess(SizedIngredient.FLAT_CODEC.listOf(), provider, nbt.get("cost"))).forEach(research::addCost);
        NBTUtils.streamCompound(nbt.getList("requirements", 10)).forEach(compound -> research.addRequirement(Objects.requireNonNull((ModResearchRequirements.ResearchRequirementEntry)IMinecoloniesAPI.getInstance().getResearchRequirementRegistry().get(ResourceLocation.tryParse((String)compound.getString("requirement-type")))).readFromNBT(compound.getCompound("requirement-item"))));
        NBTUtils.streamCompound(nbt.getList("effects", 10)).forEach(compound -> research.addEffect(Objects.requireNonNull((ModResearchEffects.ResearchEffectEntry)IMinecoloniesAPI.getInstance().getResearchEffectRegistry().get(ResourceLocation.tryParse((String)compound.getString("effect-type")))).readFromNBT(compound.getCompound("effect-item"))));
        NBTUtils.streamCompound(nbt.getList("hasResearchedChild", 10)).forEach(compound -> research.addChild(ResourceLocation.parse((String)compound.getString("child"))));
        return research;
    }

    @Override
    public void serialize(@NotNull IFactoryController controller, @NotNull IGlobalResearch input, RegistryFriendlyByteBuf packetBuffer) {
        packetBuffer.writeResourceLocation(input.getId());
        packetBuffer.writeBoolean(input.getParent() != null);
        if (input.getParent() != null) {
            packetBuffer.writeResourceLocation(input.getParent());
        }
        packetBuffer.writeResourceLocation(input.getBranch());
        packetBuffer.writeUtf(input.getName().getKey());
        packetBuffer.writeUtf(input.getSubtitle().getKey());
        packetBuffer.writeVarInt(input.getDepth());
        packetBuffer.writeVarInt(input.getSortOrder());
        packetBuffer.writeBoolean(input.hasOnlyChild());
        packetBuffer.writeBoolean(input.isInstant());
        packetBuffer.writeBoolean(input.isAutostart());
        packetBuffer.writeBoolean(input.isImmutable());
        packetBuffer.writeBoolean(input.isHidden());
        Utils.serializeCodecMess(SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), packetBuffer, input.getCostList());
        packetBuffer.writeVarInt(input.getResearchRequirements().size());
        for (IResearchRequirement req : input.getResearchRequirements()) {
            packetBuffer.writeById(arg_0 -> IMinecoloniesAPI.getInstance().getResearchRequirementRegistry().getIdOrThrow(arg_0), (Object)req.getRegistryEntry());
            packetBuffer.writeNbt((Tag)req.writeToNBT());
        }
        packetBuffer.writeVarInt(input.getEffects().size());
        for (IResearchEffect effect : input.getEffects()) {
            packetBuffer.writeById(arg_0 -> IMinecoloniesAPI.getInstance().getResearchEffectRegistry().getIdOrThrow(arg_0), (Object)effect.getRegistryEntry());
            packetBuffer.writeNbt((Tag)effect.writeToNBT());
        }
        packetBuffer.writeVarInt(input.getChildren().size());
        for (ResourceLocation child : input.getChildren()) {
            packetBuffer.writeResourceLocation(child);
        }
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
        ResourceLocation id = buffer.readResourceLocation();
        ResourceLocation parent = buffer.readBoolean() ? buffer.readResourceLocation() : null;
        ResourceLocation branch = buffer.readResourceLocation();
        TranslatableContents name = new TranslatableContents(buffer.readUtf(), null, TranslatableContents.NO_ARGS);
        TranslatableContents subtitle = new TranslatableContents(buffer.readUtf(), null, TranslatableContents.NO_ARGS);
        int depth = buffer.readVarInt();
        int sortOrder = buffer.readVarInt();
        boolean hasOnlyChild = buffer.readBoolean();
        boolean instant = buffer.readBoolean();
        boolean autostart = buffer.readBoolean();
        boolean immutable = buffer.readBoolean();
        boolean hidden = buffer.readBoolean();
        IGlobalResearch research = this.getNewInstance(id, parent, branch, name, subtitle, depth, sortOrder, hasOnlyChild, hidden, autostart, instant, immutable);
        ((List)Utils.deserializeCodecMess(SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), buffer)).forEach(research::addCost);
        int reqCount = buffer.readVarInt();
        for (int i = 0; i < reqCount; ++i) {
            ModResearchRequirements.ResearchRequirementEntry researchRequirementEntry = (ModResearchRequirements.ResearchRequirementEntry)buffer.readById(arg_0 -> IMinecoloniesAPI.getInstance().getResearchRequirementRegistry().byIdOrThrow(arg_0));
            research.addRequirement(researchRequirementEntry.readFromNBT(buffer.readNbt()));
        }
        int effectCount = buffer.readVarInt();
        for (int i = 0; i < effectCount; ++i) {
            ModResearchEffects.ResearchEffectEntry researchEffectEntry = (ModResearchEffects.ResearchEffectEntry)buffer.readById(arg_0 -> IMinecoloniesAPI.getInstance().getResearchEffectRegistry().byIdOrThrow(arg_0));
            research.addEffect(researchEffectEntry.readFromNBT(buffer.readNbt()));
        }
        int childCount = buffer.readVarInt();
        for (int i = 0; i < childCount; ++i) {
            research.addChild(buffer.readResourceLocation());
        }
        return research;
    }

    @Override
    public short getSerializationId() {
        return 28;
    }
}

