/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.recipes;

import com.minecolonies.apiimp.initializer.ModIngredientTypeInitializer;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlantIngredient
implements ICustomIngredient {
    private static final Lazy<PlantIngredient> INSTANCE = Lazy.of(PlantIngredient::new);
    public static final MapCodec<PlantIngredient> CODEC = MapCodec.unit(INSTANCE);
    private final List<ItemStack> items = BuiltInRegistries.ITEM.stream().filter(item -> {
        BlockItem block;
        return item instanceof BlockItem && ((block = (BlockItem)item).getBlock() instanceof CropBlock || block.getBlock() instanceof StemBlock);
    }).map(ItemStack::new).toList();

    private PlantIngredient() {
    }

    @NotNull
    public static Ingredient of() {
        return ((PlantIngredient)INSTANCE.get()).toVanilla();
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return this.getItems().anyMatch(s -> stack.is(s.getItem()));
    }

    @NotNull
    public Stream<ItemStack> getItems() {
        return this.items.stream();
    }

    public boolean isSimple() {
        return true;
    }

    @NotNull
    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypeInitializer.PLANT_INGREDIENT_TYPE.get();
    }
}

