/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JigsawPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.getBlock() instanceof JigsawBlock;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
        if (complete) {
            WorldUtil.setBlockState((LevelAccessor)world, pos, blockState, 3);
            if (tileEntityData != null) {
                try {
                    PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (RotationMirror)settings);
                    blockState.getBlock().setPlacedBy(world, pos, blockState, null, BlockUtils.getItemStackFromBlockState((BlockState)blockState));
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Unable to place TileEntity");
                }
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }
        if (tileEntityData != null && tileEntityData.contains("final_state")) {
            String stateString = tileEntityData.getString("final_state");
            BlockState finalState = Blocks.AIR.defaultBlockState();
            try {
                BlockStateParser.BlockResult stateParser = BlockStateParser.parseForBlock((HolderLookup)world.holderLookup(Registries.BLOCK), (String)stateString, (boolean)false);
                BlockState resultState = stateParser.blockState();
                if (resultState != null) {
                    finalState = resultState;
                }
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                Log.getLogger().warn("Unable to place Jigsaw");
            }
            if (finalState.getBlock() == Blocks.STRUCTURE_VOID) {
                return IPlacementHandler.ActionProcessingResult.SUCCESS;
            }
            WorldUtil.setBlockState((LevelAccessor)world, pos, finalState, 3);
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        if (complete) {
            return ImmutableList.of((Object)new ItemStack((ItemLike)Blocks.JIGSAW));
        }
        String stateString = tileEntityData.getString("final_state");
        BlockState finalState = Blocks.AIR.defaultBlockState();
        try {
            BlockStateParser.BlockResult stateParser = BlockStateParser.parseForBlock((HolderLookup)world.holderLookup(Registries.BLOCK), (String)stateString, (boolean)true);
            BlockState resultState = stateParser.blockState();
            if (resultState != null) {
                finalState = resultState;
            }
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            Log.getLogger().warn("Unable to place Jigsaw");
        }
        if (finalState.getBlock() == Blocks.AIR || finalState.getBlock() == Blocks.STRUCTURE_VOID) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)BlockUtils.getItemStackFromBlockState((BlockState)finalState));
    }
}

