/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionFluidHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.getBlock() instanceof LiquidBlock || blockState.getBlock() instanceof BubbleColumnBlock;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (complete) {
            itemList.add(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
            return itemList;
        }
        if (WorldUtil.isNetherType(world) && blockState.getBlock() == Blocks.LAVA) {
            return Collections.emptyList();
        }
        if (blockState.getBlock() == Blocks.WATER) {
            return Collections.emptyList();
        }
        if (!blockState.getFluidState().isSource()) {
            return Collections.emptyList();
        }
        itemList.add(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
        return itemList;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
        if (!blockState.getFluidState().isSource() && !complete) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        world.setBlock(pos, blockState, 3);
        world.scheduleTick(pos, blockState.getFluidState().getType(), blockState.getFluidState().getType().getTickDelay((LevelReader)world));
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }
}

