/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.citizen;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class TransferItemsToCitizenRequestMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"transfer_items_to_citizen_request", TransferItemsToCitizenRequestMessage::new);
    private final int citizenId;
    private final ItemStack itemStack;
    private final int quantity;

    public TransferItemsToCitizenRequestMessage(IColony colony, @NotNull ICitizenDataView citizenDataView, ItemStack itemStack, int quantity) {
        super(TYPE, colony);
        this.citizenId = citizenDataView.getId();
        this.itemStack = itemStack;
        this.quantity = quantity;
    }

    protected TransferItemsToCitizenRequestMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.citizenId = buf.readInt();
        this.itemStack = Utils.deserializeCodecMess(buf);
        this.quantity = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.citizenId);
        Utils.serializeCodecMess(buf, this.itemStack);
        buf.writeInt(this.quantity);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        int tempAmount;
        int count;
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(this.citizenId);
        if (citizenData == null) {
            Log.getLogger().warn("TransferItemsRequestMessage citizenData is null");
            return;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            Log.getLogger().warn("TransferItemsRequestMessage entity citizen is null");
            return;
        }
        boolean isCreative = player.isCreative();
        if (this.quantity <= 0 && !isCreative) {
            Log.getLogger().warn("TransferItemsRequestMessage quantity below 0");
            return;
        }
        Map<ItemStorage, ItemStorage> previousContent = null;
        int amountToTake = isCreative ? this.quantity : Math.min(this.quantity, InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack)));
        ArrayList<Object> itemsToPut = new ArrayList<Object>();
        for (tempAmount = amountToTake; tempAmount > 0; tempAmount -= count) {
            count = Math.min(this.itemStack.getMaxStackSize(), tempAmount);
            ItemStack stack2 = this.itemStack.copy();
            stack2.setCount(count);
            itemsToPut.add(stack2);
        }
        AbstractEntityCitizen citizen = optionalEntityCitizen.get();
        if (!isCreative && ((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).debugInventories.get()).booleanValue()) {
            previousContent = InventoryUtils.getAllItemsForProviders(new IItemHandler[]{citizen.getInventoryCitizen(), new InvWrapper((Container)player.getInventory())});
        }
        tempAmount = 0;
        for (ItemStack itemStack : itemsToPut) {
            ItemStack remainingItemStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)citizen.getInventoryCitizen(), itemStack);
            if (!ItemStackUtils.isEmpty(remainingItemStack)) {
                tempAmount += itemStack.getCount() - remainingItemStack.getCount();
                break;
            }
            tempAmount += itemStack.getCount();
        }
        if (!isCreative) {
            ItemStack itemsTaken;
            for (int amountToRemoveFromPlayer = tempAmount; amountToRemoveFromPlayer > 0; amountToRemoveFromPlayer -= ItemStackUtils.getSize(itemsTaken)) {
                int n = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.getInventory()), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack));
                itemsTaken = player.getInventory().removeItem(n, amountToRemoveFromPlayer);
            }
        }
        if (!isCreative && previousContent != null && ((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).debugInventories.get()).booleanValue()) {
            InventoryUtils.doStorageSetsMatch(previousContent, InventoryUtils.getAllItemsForProviders(new IItemHandler[]{citizen.getInventoryCitizen(), new InvWrapper((Container)player.getInventory())}), true);
        }
    }
}

