/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.enchanter;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.modules.EnchanterStationsModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class EnchanterWorkerSetMessage
extends AbstractBuildingServerMessage<BuildingEnchanter> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"enchanter_worker_set", EnchanterWorkerSetMessage::new);
    private final BlockPos worker;
    private final boolean add;

    public EnchanterWorkerSetMessage(@NotNull IBuildingView building, BlockPos worker, boolean add) {
        super(TYPE, building);
        this.worker = worker;
        this.add = add;
    }

    protected EnchanterWorkerSetMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.worker = buf.readBlockPos();
        this.add = buf.readBoolean();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBlockPos(this.worker);
        buf.writeBoolean(this.add);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, BuildingEnchanter building) {
        if (this.add) {
            ((EnchanterStationsModule)building.getFirstModuleOccurance(EnchanterStationsModule.class)).addWorker(this.worker);
        } else {
            ((EnchanterStationsModule)building.getFirstModuleOccurance(EnchanterStationsModule.class)).removeWorker(this.worker);
        }
    }
}

