/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class HireFireMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"hire_fire", HireFireMessage::new);
    private final boolean hire;
    private final int citizenID;
    private final int moduleId;

    public HireFireMessage(@NotNull IBuildingView building, boolean hire, int citizenID, int moduleId) {
        super(TYPE, building);
        this.hire = hire;
        this.citizenID = citizenID;
        this.moduleId = moduleId;
    }

    protected HireFireMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.hire = buf.readBoolean();
        this.citizenID = buf.readInt();
        this.moduleId = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.hire);
        buf.writeInt(this.citizenID);
        buf.writeInt(this.moduleId);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.moduleId);
        if (iBuildingModule instanceof IAssignsJob) {
            IAssignsJob module = (IAssignsJob)iBuildingModule;
            ICitizenData citizen = colony.getCitizenManager().getCivilian(this.citizenID);
            citizen.setPaused(false);
            if (this.hire) {
                module.assignCitizen(citizen);
            } else {
                module.removeCitizen(citizen);
            }
        }
    }
}

