/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColonyServerMessage
extends AbstractServerPlayMessage {
    private final ResourceKey<Level> dimensionId;
    private final int colonyId;

    public AbstractColonyServerMessage(PlayMessageType<?> type, IColony colony) {
        this(type, colony.getDimension(), colony.getID());
    }

    public AbstractColonyServerMessage(PlayMessageType<?> type, ResourceKey<Level> dimensionId, int colonyId) {
        super(type);
        this.dimensionId = dimensionId;
        this.colonyId = colonyId;
    }

    @Nullable
    protected Action permissionNeeded() {
        return Action.MANAGE_HUTS;
    }

    public boolean ownerOnly() {
        return false;
    }

    protected abstract void onExecute(IPayloadContext var1, ServerPlayer var2, IColony var3);

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUtf(this.dimensionId.location().toString());
        buf.writeInt(this.colonyId);
    }

    protected AbstractColonyServerMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.dimensionId = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.colonyId = buf.readInt();
    }

    public final void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, this.dimensionId);
        if (colony != null) {
            if (!this.ownerOnly() && this.permissionNeeded() != null && !colony.getPermissions().hasPermission((Player)player, this.permissionNeeded())) {
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.permission.deny", new Object[0]).sendTo(new Player[]{player});
                return;
            }
            if (this.ownerOnly() && !colony.getPermissions().getOwner().equals(player.getUUID())) {
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.permission.deny", new Object[0]).sendTo(new Player[]{player});
                return;
            }
            this.onExecute(ctxIn, player, colony);
        } else {
            MessageUtils.format("com.minecolonies.coremod.gui.nocolony", ((Object)((Object)this)).getClass().getSimpleName()).sendTo(new Player[]{player});
        }
    }
}

