/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.research.IResearchManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewResearchManagerViewMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view_research_manager_view", ColonyViewResearchManagerViewMessage::new);
    private final int colonyId;
    private final CompoundTag researchManagerData;
    private final ResourceKey<Level> dimension;

    public ColonyViewResearchManagerViewMessage(IColony colony, @NotNull IResearchManager researchManager) {
        super(TYPE);
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        CompoundTag researchCompound = new CompoundTag();
        researchManager.writeToNBT((HolderLookup.Provider)colony.getWorld().registryAccess(), researchCompound);
        this.researchManagerData = researchCompound;
    }

    public ColonyViewResearchManagerViewMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.researchManagerData = buf.readNbt();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeUtf(this.dimension.location().toString());
        buf.writeNbt((Tag)this.researchManagerData);
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (colonyView != null) {
            colonyView.handleColonyViewResearchManagerUpdate((HolderLookup.Provider)player.level().registryAccess(), this.researchManagerData);
        }
    }
}

