/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.util.Log;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class UpdateClientWithCompatibilityMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"update_client_with_compatibility", UpdateClientWithCompatibilityMessage::new, (boolean)true, (boolean)false);
    private final RegistryFriendlyByteBuf buffer;

    public UpdateClientWithCompatibilityMessage(@NotNull RegistryAccess provider) {
        super(TYPE);
        this.buffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), provider);
        IMinecoloniesAPI.getInstance().getColonyManager().getCompatibilityManager().serialize(this.buffer);
    }

    protected UpdateClientWithCompatibilityMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.buffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray())), buf.registryAccess());
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeByteArray(this.buffer.array());
        this.buffer.resetWriterIndex();
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        ClientLevel world = Minecraft.getInstance().level;
        try {
            IMinecoloniesAPI.getInstance().getColonyManager().getCompatibilityManager().deserialize(this.buffer, world);
        }
        catch (Exception e) {
            Log.getLogger().error("Failed to load compatibility manager", (Throwable)e);
        }
    }
}

