/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.core.client.render.worldevent.PathfindingDebugRenderer;
import com.minecolonies.core.entity.pathfinding.MNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncPathMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"sync_path", SyncPathMessage::new);
    public Set<MNode> lastDebugNodesVisited = new HashSet<MNode>();
    public Set<MNode> lastDebugNodesNotVisited = new HashSet<MNode>();
    public Set<MNode> lastDebugNodesPath = new HashSet<MNode>();
    public Set<MNode> debugNodesVisitedLater = new HashSet<MNode>();
    public Set<MNode> debugNodesOrgPath = new HashSet<MNode>();
    public Set<MNode> debugNodesExtra = new HashSet<MNode>();

    public SyncPathMessage(Set<MNode> lastDebugNodesVisited, Set<MNode> lastDebugNodesNotVisited, Set<MNode> lastDebugNodesPath, Set<MNode> debugNodesVisitedLater, Set<MNode> debugNodesOrgPath, Set<MNode> debugNodesExtra) {
        super(TYPE);
        this.lastDebugNodesVisited = lastDebugNodesVisited;
        this.lastDebugNodesNotVisited = lastDebugNodesNotVisited;
        this.lastDebugNodesPath = lastDebugNodesPath;
        this.debugNodesVisitedLater = debugNodesVisitedLater;
        this.debugNodesOrgPath = debugNodesOrgPath;
        this.debugNodesExtra = debugNodesExtra;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.lastDebugNodesVisited.size());
        for (MNode node : this.lastDebugNodesVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesNotVisited.size());
        for (MNode node : this.lastDebugNodesNotVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesPath.size());
        for (MNode node : this.lastDebugNodesPath) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.debugNodesVisitedLater.size());
        for (MNode node : this.debugNodesVisitedLater) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.debugNodesOrgPath.size());
        for (MNode node : this.debugNodesOrgPath) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.debugNodesExtra.size());
        for (MNode node : this.debugNodesExtra) {
            node.serializeToBuf(buf);
        }
    }

    protected SyncPathMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(type);
        int i;
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesVisited.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesNotVisited.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesPath.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.debugNodesVisitedLater.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.debugNodesOrgPath.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.debugNodesExtra.add(new MNode(buf));
        }
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        PathfindingDebugRenderer.lastDebugNodesVisited = this.lastDebugNodesVisited;
        PathfindingDebugRenderer.lastDebugNodesNotVisited = this.lastDebugNodesNotVisited;
        PathfindingDebugRenderer.lastDebugNodesPath = this.lastDebugNodesPath;
        PathfindingDebugRenderer.lastDebugNodesVisitedLater = this.debugNodesVisitedLater;
        PathfindingDebugRenderer.debugNodesOrgPath = this.debugNodesOrgPath;
        PathfindingDebugRenderer.debugNodesExtra = this.debugNodesExtra;
    }
}

