/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.client.gui.townhall.WindowTownHallCantCreateColony;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OpenCantFoundColonyWarningMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"open_cant_found_colony_warning", OpenCantFoundColonyWarningMessage::new);
    private BlockPos townHallPos;
    private Component warningMessageTranslationKey;
    private boolean displayConfigTooltip;

    public OpenCantFoundColonyWarningMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(type);
        this.warningMessageTranslationKey = (Component)Utils.deserializeCodecMess(ComponentSerialization.STREAM_CODEC, buf);
        this.townHallPos = buf.readBlockPos();
        this.displayConfigTooltip = buf.readBoolean();
    }

    public OpenCantFoundColonyWarningMessage(Component warningMessageTranslationKey, BlockPos townHallPos, boolean displayConfigTooltip) {
        super(TYPE);
        this.warningMessageTranslationKey = warningMessageTranslationKey;
        this.townHallPos = townHallPos;
        this.displayConfigTooltip = displayConfigTooltip;
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        new WindowTownHallCantCreateColony(this.townHallPos, (MutableComponent)this.warningMessageTranslationKey, this.displayConfigTooltip).open();
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        Utils.serializeCodecMess(ComponentSerialization.STREAM_CODEC, buf, this.warningMessageTranslationKey);
        buf.writeBlockPos(this.townHallPos);
        buf.writeBoolean(this.displayConfigTooltip);
    }
}

