/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.util.Utils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class LocalizedParticleEffectMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"localized_particle_effect", LocalizedParticleEffectMessage::new);
    private static final Random RAND = new Random();
    private final ItemStack stack;
    private final double posX;
    private final double posY;
    private final double posZ;

    public LocalizedParticleEffectMessage(ItemStack stack, BlockPos pos) {
        super(TYPE);
        this.stack = stack;
        this.posX = (double)pos.getX() + 0.5;
        this.posY = (double)pos.getY() + 0.5;
        this.posZ = (double)pos.getZ() + 0.5;
    }

    protected LocalizedParticleEffectMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.stack = Utils.deserializeCodecMess(buf);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        Utils.serializeCodecMess(buf, this.stack);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        for (int i = 0; i < 5; ++i) {
            Vec3 randomPos = new Vec3((RAND.nextDouble() - 0.5) * 0.1, RAND.nextDouble() * 0.1 + 0.1, 0.0);
            Vec3 randomOffset = new Vec3((RAND.nextDouble() - 0.5) * 0.1, RAND.nextDouble() - 0.05, (RAND.nextDouble() - 0.5) * 0.1);
            player.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.stack), this.posX + randomOffset.x, this.posY + randomOffset.y, this.posZ + randomOffset.z, randomPos.x, randomPos.y + 0.05, randomPos.z);
        }
    }
}

