/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionsMessage {

    public static class EditRankType
    extends AbstractColonyServerMessage {
        public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"permission_edit_rank_type", EditRankType::new);
        private final int rankId;
        private final int rankType;

        public EditRankType(@NotNull IColonyView colony, @NotNull Rank rank, int rankType) {
            super(TYPE, colony);
            this.rankId = rank.getId();
            this.rankType = rankType;
        }

        @Override
        protected void toBytes(RegistryFriendlyByteBuf buf) {
            super.toBytes(buf);
            buf.writeInt(this.rankId);
            buf.writeInt(this.rankType);
        }

        protected EditRankType(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
            super(buf, type);
            this.rankId = buf.readInt();
            this.rankType = buf.readInt();
        }

        @Override
        protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
            Rank rank = colony.getPermissions().getRank(this.rankId);
            switch (this.rankType) {
                case 0: {
                    rank.setColonyManager(true);
                    rank.setHostile(false);
                    break;
                }
                case 1: {
                    rank.setHostile(true);
                    rank.setColonyManager(false);
                    break;
                }
                default: {
                    rank.setHostile(false);
                    rank.setColonyManager(false);
                }
            }
            colony.markDirty();
        }

        @Override
        @Nullable
        protected Action permissionNeeded() {
            return Action.EDIT_PERMISSIONS;
        }
    }

    public static class RemoveRank
    extends AbstractColonyServerMessage {
        public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"permission_remove_rank", RemoveRank::new);
        private final int rankId;

        public RemoveRank(@NotNull IColonyView colony, @NotNull Rank rank) {
            super(TYPE, colony);
            this.rankId = rank.getId();
        }

        @Override
        protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
            super.toBytes(buf);
            buf.writeInt(this.rankId);
        }

        protected RemoveRank(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
            super(buf, type);
            this.rankId = buf.readInt();
        }

        @Override
        protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
            colony.getPermissions().removeRank(colony.getPermissions().getRanks().get(this.rankId));
        }

        @Override
        @Nullable
        protected Action permissionNeeded() {
            return Action.EDIT_PERMISSIONS;
        }
    }

    public static class RemovePlayer
    extends AbstractColonyServerMessage {
        public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"permission_remove_player", RemovePlayer::new);
        private final UUID playerID;

        public RemovePlayer(@NotNull IColonyView colony, UUID player) {
            super(TYPE, colony);
            this.playerID = player;
        }

        @Override
        protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
            super.toBytes(buf);
            buf.writeUUID(this.playerID);
        }

        protected RemovePlayer(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
            super(buf, type);
            this.playerID = buf.readUUID();
        }

        @Override
        protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
            ColonyPlayer permissionsPlayer = colony.getPermissions().getPlayers().get(this.playerID);
            if (permissionsPlayer.getRank().isHostile() && colony.getPermissions().hasPermission((Player)player, Action.EDIT_PERMISSIONS) || !permissionsPlayer.getRank().isHostile() && colony.getPermissions().hasPermission((Player)player, Action.EDIT_PERMISSIONS) && colony.getPermissions().getRank((Player)player).isColonyManager() || player.getUUID().equals(this.playerID)) {
                colony.getPermissions().removePlayer(this.playerID);
            }
        }

        @Override
        @Nullable
        protected Action permissionNeeded() {
            return Action.EDIT_PERMISSIONS;
        }
    }

    public static class ChangePlayerRank
    extends AbstractColonyServerMessage {
        public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"permission_change_player_rank", ChangePlayerRank::new);
        private final UUID playerID;
        private final int rankId;

        public ChangePlayerRank(@NotNull IColonyView colony, UUID player, Rank rank) {
            super(TYPE, colony);
            this.playerID = player;
            this.rankId = rank.getId();
        }

        @Override
        protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
            super.toBytes(buf);
            buf.writeUUID(this.playerID);
            buf.writeInt(this.rankId);
        }

        protected ChangePlayerRank(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
            super(buf, type);
            this.playerID = buf.readUUID();
            this.rankId = buf.readInt();
        }

        @Override
        protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
            Rank rank = colony.getPermissions().getRanks().get(this.rankId);
            if (colony.getPermissions().hasPermission((Player)player, Action.EDIT_PERMISSIONS) && rank != colony.getPermissions().getRankOwner()) {
                colony.getPermissions().setPlayerRank(this.playerID, rank, colony.getWorld());
            }
        }

        @Override
        @Nullable
        protected Action permissionNeeded() {
            return Action.EDIT_PERMISSIONS;
        }
    }

    public static class AddPlayerOrFakePlayer
    extends AbstractColonyServerMessage {
        public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"permission_add_player_or_fake_player", AddPlayerOrFakePlayer::new);
        private final String playerName;
        private final UUID id;

        public AddPlayerOrFakePlayer(@NotNull IColonyView colony, String playerName, UUID id) {
            super(TYPE, colony);
            this.playerName = playerName;
            this.id = id;
        }

        @Override
        protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
            super.toBytes(buf);
            buf.writeUtf(this.playerName);
            buf.writeUUID(this.id);
        }

        protected AddPlayerOrFakePlayer(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
            super(buf, type);
            this.playerName = buf.readUtf(Short.MAX_VALUE);
            this.id = buf.readUUID();
        }

        @Override
        protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
            colony.getPermissions().addPlayer(this.id, this.playerName, colony.getPermissions().getRank(3));
            Optional.ofNullable(colony.getBuildingManager().getTownHall()).ifPresent(th -> th.removePermissionEvents(this.id));
            SoundUtils.playSuccessSound((Player)player, player.blockPosition());
        }

        @Override
        @Nullable
        protected Action permissionNeeded() {
            return Action.EDIT_PERMISSIONS;
        }
    }

    public static class AddRank
    extends AbstractColonyServerMessage {
        public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"permission_add_rank", AddRank::new);
        private final String rankName;

        public AddRank(@NotNull IColonyView colony, @NotNull String name) {
            super(TYPE, colony);
            this.rankName = name;
        }

        @Override
        protected void toBytes(RegistryFriendlyByteBuf buf) {
            super.toBytes(buf);
            buf.writeUtf(this.rankName);
        }

        protected AddRank(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
            super(buf, type);
            this.rankName = buf.readUtf(Short.MAX_VALUE);
        }

        @Override
        protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
            colony.getPermissions().addRank(this.rankName);
        }

        @Override
        @Nullable
        protected Action permissionNeeded() {
            return Action.EDIT_PERMISSIONS;
        }
    }

    public static class AddPlayer
    extends AbstractColonyServerMessage {
        public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"permission_add_player", AddPlayer::new);
        private final String playerName;

        public AddPlayer(@NotNull IColonyView colony, String player) {
            super(TYPE, colony);
            this.playerName = player;
        }

        @Override
        protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
            super.toBytes(buf);
            buf.writeUtf(this.playerName);
        }

        protected AddPlayer(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
            super(buf, type);
            this.playerName = buf.readUtf(Short.MAX_VALUE);
        }

        @Override
        protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
            colony.getPermissions().addPlayer(this.playerName, colony.getPermissions().getRank(3), colony.getWorld());
        }

        @Override
        @Nullable
        protected Action permissionNeeded() {
            return Action.EDIT_PERMISSIONS;
        }
    }

    public static class Permission
    extends AbstractColonyServerMessage {
        public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"permission_permission", Permission::new);
        private final boolean enable;
        private final int rankId;
        private final Action action;

        public Permission(@NotNull IColonyView colony, boolean enable, Rank rank, Action action) {
            super(TYPE, colony);
            this.enable = enable;
            this.rankId = rank.getId();
            this.action = action;
        }

        @Override
        protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
            colony.getPermissions().alterPermission(colony.getPermissions().getRank((Player)player), colony.getPermissions().getRanks().get(this.rankId), this.action, this.enable);
        }

        @Override
        protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
            super.toBytes(buf);
            buf.writeBoolean(this.enable);
            buf.writeInt(this.rankId);
            buf.writeUtf(this.action.name());
        }

        protected Permission(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
            super(buf, type);
            this.enable = buf.readBoolean();
            this.rankId = buf.readInt();
            this.action = Action.valueOf(buf.readUtf(Short.MAX_VALUE));
        }
    }

    public static class View
    extends AbstractClientPlayMessage {
        public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"permission_view", View::new, (boolean)true, (boolean)false);
        private final int colonyID;
        private final RegistryFriendlyByteBuf data;
        private final ResourceKey<Level> dimension;

        public View(@NotNull Colony colony, @NotNull Rank viewerRank) {
            super(TYPE);
            this.colonyID = colony.getID();
            this.data = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), colony.getWorld().registryAccess());
            colony.getPermissions().serializeViewNetworkData(this.data, viewerRank);
            this.dimension = colony.getDimension();
        }

        protected View(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
            super(buf, type);
            this.colonyID = buf.readInt();
            this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
            this.data = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray())), buf.registryAccess());
        }

        protected void onExecute(IPayloadContext ctxIn, @Nullable Player player) {
            IColonyManager.getInstance().handlePermissionsViewMessage(this.colonyID, this.data, this.dimension);
        }

        protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
            this.data.resetReaderIndex();
            buf.writeInt(this.colonyID);
            buf.writeUtf(this.dimension.location().toString());
            buf.writeByteArray(this.data.array());
        }
    }
}

