/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.navigation;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.api.entity.pathfinding.IMinecoloniesNavigator;
import com.minecolonies.api.entity.pathfinding.IStuckHandler;
import com.minecolonies.api.entity.pathfinding.IStuckHandlerEntity;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLEnvironment;

public class PathingStuckHandler<NAV extends PathNavigation>
implements IStuckHandler<NAV> {
    private static final double MIN_TARGET_DIST = 3.0;
    private static final int MIN_TP_DELAY = 2400;
    private static final int MIN_DIST_FOR_TP = 10;
    private static final int TICKS_PER_BLOCK = 7;
    private static final int STARTING_STUCK_LEVEL = -5;
    private int teleportRange = 0;
    private int timePerBlockDistance = 200;
    private int stuckLevel = -5;
    private int globalTimeout = 0;
    private BlockPos prevDestination = BlockPos.ZERO;
    private boolean canBreakBlocks = false;
    private boolean canPlaceLadders = false;
    private boolean canBuildLeafBridges = false;
    private boolean canTeleportGoal = false;
    private boolean takeDamageOnCompleteStuck = false;
    private float damagePct = 0.2f;
    private int completeStuckBlockBreakRange = 0;
    private double chanceToByPassMovingAway = 0.0;
    private boolean hadPath = false;
    private int lastPathIndex = -1;
    private int progressedNodes = 0;
    private int delayBeforeActions;
    private int delayToNextUnstuckAction = this.delayBeforeActions = 100;
    private BlockPos moveAwayStartPos = BlockPos.ZERO;
    private Direction movingAwayDir = Direction.EAST;
    private Random rand = new Random();

    private PathingStuckHandler() {
    }

    public static <NAV extends PathNavigation> PathingStuckHandler<NAV> createStuckHandler() {
        return new PathingStuckHandler<NAV>();
    }

    @Override
    public void checkStuck(NAV navigator) {
        double distanceToGoal;
        if (((IMinecoloniesNavigator)navigator).getPathResult() == null) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (((IMinecoloniesNavigator)navigator).getOurEntity() instanceof IStuckHandlerEntity && !((IStuckHandlerEntity)((IMinecoloniesNavigator)navigator).getOurEntity()).canBeStuck()) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (Objects.equals(this.prevDestination, ((IMinecoloniesNavigator)navigator).getSafeDestination())) {
            this.globalTimeout += 10;
            if (this.globalTimeout > 2400) {
                if (((IMinecoloniesNavigator)navigator).getSafeDestination() != null && ((IMinecoloniesNavigator)navigator).getSafeDestination() != BlockPos.ZERO) {
                    int distance = Math.max(10, BlockPosUtil.distManhattan(((IMinecoloniesNavigator)navigator).getSafeDestination(), ((IMinecoloniesNavigator)navigator).getOurEntity().blockPosition()));
                    if (this.globalTimeout > this.timePerBlockDistance * distance) {
                        this.completeStuckAction(navigator);
                    }
                } else {
                    this.completeStuckAction(navigator);
                }
            }
        } else {
            this.resetGlobalStuckTimers();
        }
        this.prevDestination = ((IMinecoloniesNavigator)navigator).getSafeDestination();
        if (this.prevDestination != null && this.prevDestination != BlockPos.ZERO && (distanceToGoal = ((IMinecoloniesNavigator)navigator).getOurEntity().position().distanceTo(new Vec3((double)((IMinecoloniesNavigator)navigator).getSafeDestination().getX(), (double)((IMinecoloniesNavigator)navigator).getSafeDestination().getY(), (double)((IMinecoloniesNavigator)navigator).getSafeDestination().getZ()))) < 3.0) {
            this.resetGlobalStuckTimers();
            return;
        }
        this.delayToNextUnstuckAction -= 10;
        if (navigator.getPath() == null || navigator.getPath().isDone()) {
            this.lastPathIndex = -1;
            this.progressedNodes = 0;
            if (!this.hadPath) {
                this.tryUnstuck(navigator);
            }
        } else if (navigator.getPath().getNextNodeIndex() == this.lastPathIndex) {
            this.tryUnstuck(navigator);
        } else if (this.lastPathIndex != -1) {
            this.delayToNextUnstuckAction = Math.max(this.delayToNextUnstuckAction, 100);
            if (this.stuckLevel == 0 || this.prevDestination != null && this.prevDestination != BlockPos.ZERO && navigator.getPath().getTarget().distSqr((Vec3i)this.prevDestination) < 25.0) {
                int n = this.progressedNodes = navigator.getPath().getNextNodeIndex() > this.lastPathIndex ? this.progressedNodes + 1 : this.progressedNodes;
                if (!(this.progressedNodes <= 5 || navigator.getPath().getEndNode() != null && this.moveAwayStartPos.equals((Object)navigator.getPath().getEndNode().asBlockPos()))) {
                    this.resetStuckTimers();
                }
            }
        }
        this.lastPathIndex = navigator.getPath() != null ? navigator.getPath().getNextNodeIndex() : -1;
        this.hadPath = navigator.getPath() != null && !navigator.getPath().isDone();
    }

    @Override
    public void resetGlobalStuckTimers() {
        this.globalTimeout = 0;
        this.prevDestination = BlockPos.ZERO;
        this.resetStuckTimers();
    }

    private void completeStuckAction(NAV navigator) {
        BlockPos tpPos;
        BlockPos desired = ((IMinecoloniesNavigator)navigator).getSafeDestination();
        Level world = ((IMinecoloniesNavigator)navigator).getOurEntity().level();
        Mob entity = ((IMinecoloniesNavigator)navigator).getOurEntity();
        if (!FMLEnvironment.production) {
            Log.getLogger().warn("Entity complete stuck action stuck:" + String.valueOf(((IMinecoloniesNavigator)navigator).getOurEntity()) + " desired:" + String.valueOf(((IMinecoloniesNavigator)navigator).getSafeDestination()) + " stuckLevel:" + this.stuckLevel + " teleport:" + this.canTeleportGoal);
        }
        if (this.canTeleportGoal && desired != null && desired != BlockPos.ZERO && (tpPos = BlockPosUtil.findAround(world, desired, 10, 10, (posworld, pos) -> SurfaceType.getSurfaceType(posworld, posworld.getBlockState(pos.below()), pos.below()) == SurfaceType.WALKABLE && SurfaceType.getSurfaceType(posworld, posworld.getBlockState(pos), pos) == SurfaceType.DROPABLE && SurfaceType.getSurfaceType(posworld, posworld.getBlockState(pos.above()), pos.above()) == SurfaceType.DROPABLE)) != null) {
            entity.teleportTo((double)tpPos.getX() + 0.5, (double)tpPos.getY(), (double)tpPos.getZ() + 0.5);
        }
        if (this.takeDamageOnCompleteStuck) {
            entity.hurt(world.damageSources().source(DamageSourceKeys.STUCK_DAMAGE), entity.getMaxHealth() * this.damagePct);
        }
        if (this.completeStuckBlockBreakRange > 0) {
            BlockPos neighbour = this.prevDestination != null && this.prevDestination != BlockPos.ZERO ? this.prevDestination : (navigator.getPath() != null ? navigator.getPath().getTarget() : entity.blockPosition().east());
            Direction facing = BlockPosUtil.getFacing(BlockPos.containing((Position)entity.position()), neighbour);
            for (int i = 1; i <= this.completeStuckBlockBreakRange; ++i) {
                if (world.isEmptyBlock(BlockPos.containing((Position)entity.position()).relative(facing, i)) && world.isEmptyBlock(BlockPos.containing((Position)entity.position()).relative(facing, i).above())) continue;
                this.breakBlocksAhead(world, BlockPos.containing((Position)entity.position()).relative(facing, i - 1), facing);
                break;
            }
        }
        navigator.stop();
        this.resetGlobalStuckTimers();
    }

    private void tryUnstuck(NAV navigator) {
        if (this.delayToNextUnstuckAction > 0) {
            return;
        }
        this.delayToNextUnstuckAction = 50;
        if (this.stuckLevel < 0) {
            if (navigator.getPath() != null && !navigator.isDone() && navigator.getPath().getNextNodeIndex() < navigator.getPath().getNodeCount() - 1) {
                navigator.getPath().setNextNodeIndex(navigator.getPath().getNextNodeIndex() + 1);
                this.delayToNextUnstuckAction = 30;
                ++this.stuckLevel;
            } else {
                this.stuckLevel = 0;
            }
            return;
        }
        if (this.stuckLevel == 0) {
            ++this.stuckLevel;
            this.delayToNextUnstuckAction = 200;
            ((IMinecoloniesNavigator)navigator).getOurEntity().stopRiding();
            ((IMinecoloniesNavigator)navigator).recalc();
            return;
        }
        int lastStuckLevel = this.stuckLevel;
        this.chanceStuckLevel(navigator);
        if (this.rand.nextDouble() < this.chanceToByPassMovingAway || lastStuckLevel == 1 || lastStuckLevel >= 3 && lastStuckLevel <= 8 && !this.canBreakBlocks && !this.canBuildLeafBridges && !this.canPlaceLadders && this.rand.nextBoolean()) {
            this.moveAwayStartPos = navigator.getPath() != null ? navigator.getPath().getNodePos(navigator.getPath().getNextNodeIndex()) : ((IMinecoloniesNavigator)navigator).getOurEntity().blockPosition().above();
            int range = ColonyConstants.rand.nextInt(20) + 20;
            ((IMinecoloniesNavigator)navigator).setPauseTicks(0);
            ((MinecoloniesAdvancedPathNavigate)navigator).walkTowards(((IMinecoloniesNavigator)navigator).getOurEntity().blockPosition().relative(this.movingAwayDir, 40), range, 1.0);
            this.movingAwayDir = this.movingAwayDir.getClockWise();
            ((IMinecoloniesNavigator)navigator).setPauseTicks(range * 7);
            this.delayToNextUnstuckAction = (int)((double)(range * 7) * 1.5);
            return;
        }
        if (lastStuckLevel == 2 && this.teleportRange > 0 && this.hadPath) {
            int index = Math.min(navigator.getPath().getNextNodeIndex() + this.teleportRange, navigator.getPath().getNodeCount() - 1);
            Node togo = navigator.getPath().getNode(index);
            ((IMinecoloniesNavigator)navigator).getOurEntity().teleportTo((double)togo.x + 0.5, (double)togo.y, (double)togo.z + 0.5);
            this.delayToNextUnstuckAction = 200;
        }
        if (lastStuckLevel >= 3 && lastStuckLevel <= 5) {
            if (this.canPlaceLadders && this.rand.nextBoolean()) {
                this.delayToNextUnstuckAction = 200;
                this.placeLadders(navigator);
            } else if (this.canBuildLeafBridges) {
                this.delayToNextUnstuckAction = 100;
                this.placeLeaves(navigator);
            }
        }
        if (lastStuckLevel >= 6 && lastStuckLevel <= 8 && this.canBreakBlocks) {
            this.delayToNextUnstuckAction = 200;
            this.breakBlocks(navigator);
        }
        if (lastStuckLevel == 9) {
            this.completeStuckAction(navigator);
            this.resetStuckTimers();
        }
    }

    private void chanceStuckLevel(NAV nav) {
        ++this.stuckLevel;
        if (this.stuckLevel > 1 && this.rand.nextInt(6) == 0) {
            this.stuckLevel = Math.max(1, this.stuckLevel - 2);
        }
    }

    private void resetStuckTimers() {
        this.delayToNextUnstuckAction = this.delayBeforeActions;
        this.lastPathIndex = -1;
        this.progressedNodes = 0;
        this.stuckLevel = -5;
        this.moveAwayStartPos = BlockPos.ZERO;
    }

    private boolean breakBlocksAhead(Level world, BlockPos start, Direction facing) {
        if (!world.isEmptyBlock(start)) {
            this.setAirIfPossible(world, start);
            return true;
        }
        if (!world.isEmptyBlock(start.above(3))) {
            this.setAirIfPossible(world, start.above(3));
            return true;
        }
        if (!world.isEmptyBlock(start.above().relative(facing))) {
            this.setAirIfPossible(world, start.above().relative(facing));
            return true;
        }
        if (!world.isEmptyBlock(start.relative(facing))) {
            this.setAirIfPossible(world, start.relative(facing));
            return true;
        }
        return false;
    }

    private void setAirIfPossible(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        Block blockAtPos = state.getBlock();
        if (blockAtPos instanceof IBuilderUndestroyable || state.is(ModTags.indestructible)) {
            return;
        }
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
    }

    private void placeLadders(NAV navigator) {
        Level world = ((IMinecoloniesNavigator)navigator).getOurEntity().level();
        Mob entity = ((IMinecoloniesNavigator)navigator).getOurEntity();
        BlockPos entityPos = entity.blockPosition();
        while (world.getBlockState(entityPos).getBlock() == Blocks.LADDER) {
            entityPos = entityPos.above();
        }
        this.tryPlaceLadderAt(world, entityPos);
        this.tryPlaceLadderAt(world, entityPos.above());
        this.tryPlaceLadderAt(world, entityPos.above(2));
    }

    private void placeLeaves(NAV navigator) {
        Level world = ((IMinecoloniesNavigator)navigator).getOurEntity().level();
        Mob entity = ((IMinecoloniesNavigator)navigator).getOurEntity();
        Direction badFacing = ((IMinecoloniesNavigator)navigator).getSafeDestination() == null ? entity.getDirection().getOpposite() : BlockPosUtil.getFacing(BlockPos.containing((Position)entity.position()), ((IMinecoloniesNavigator)navigator).getSafeDestination()).getOpposite();
        for (Direction dir : BlockPosUtil.HORIZONTAL_DIRS) {
            if (dir == badFacing) continue;
            for (int i = 1; i <= (dir == badFacing.getOpposite() ? 3 : 1) && this.tryPlaceLeaveOnPos(world, BlockPos.containing((Position)entity.position()).below().relative(dir, i)); ++i) {
            }
        }
    }

    private boolean tryPlaceLeaveOnPos(Level world, BlockPos pos) {
        if (world.isEmptyBlock(pos)) {
            world.setBlockAndUpdate(pos, Blocks.ACACIA_LEAVES.defaultBlockState());
            return true;
        }
        return false;
    }

    private void breakBlocks(NAV navigator) {
        Direction facing;
        Level world = ((IMinecoloniesNavigator)navigator).getOurEntity().level();
        Mob entity = ((IMinecoloniesNavigator)navigator).getOurEntity();
        Direction direction = facing = ((IMinecoloniesNavigator)navigator).getSafeDestination() == null ? entity.getDirection() : BlockPosUtil.getFacing(BlockPos.containing((Position)entity.position()), ((IMinecoloniesNavigator)navigator).getSafeDestination());
        if (this.breakBlocksAhead(world, entity.blockPosition(), facing) && entity.getHealth() >= entity.getMaxHealth() / 3.0f) {
            entity.hurt(world.damageSources().source(DamageSourceKeys.STUCK_DAMAGE), (float)Math.max(0.5, (double)entity.getHealth() / 20.0));
        }
    }

    private void tryPlaceLadderAt(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if ((this.canBreakBlocks || state.canBeReplaced() || state.isAir()) && state.getBlock() != Blocks.LADDER && !(state.getBlock() instanceof IBuilderUndestroyable) && !state.is(ModTags.indestructible)) {
            for (Direction dir : BlockPosUtil.HORIZONTAL_DIRS) {
                BlockState toPlace = (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)dir.getOpposite());
                if (!BlockUtils.isAnySolid((BlockState)world.getBlockState(pos.relative(dir))) || !toPlace.canSurvive((LevelReader)world, pos)) continue;
                world.setBlockAndUpdate(pos, toPlace);
                break;
            }
        }
    }

    public PathingStuckHandler withBlockBreaks() {
        this.canBreakBlocks = true;
        return this;
    }

    public PathingStuckHandler withPlaceLadders() {
        this.canPlaceLadders = true;
        return this;
    }

    public PathingStuckHandler withBuildLeafBridges() {
        this.canBuildLeafBridges = true;
        return this;
    }

    public PathingStuckHandler withChanceToByPassMovingAway(double chance) {
        this.chanceToByPassMovingAway = chance;
        return this;
    }

    public PathingStuckHandler withTeleportSteps(int steps) {
        this.teleportRange = steps;
        return this;
    }

    public PathingStuckHandler withTeleportOnFullStuck() {
        this.canTeleportGoal = true;
        return this;
    }

    public PathingStuckHandler withTakeDamageOnStuck(float damagePct) {
        this.damagePct = damagePct;
        this.takeDamageOnCompleteStuck = true;
        return this;
    }

    public PathingStuckHandler withTimePerBlockDistance(int time) {
        this.timePerBlockDistance = time;
        return this;
    }

    public PathingStuckHandler withDelayBeforeStuckActions(int delay) {
        this.delayBeforeActions = delay;
        return this;
    }

    public PathingStuckHandler withCompleteStuckBlockBreak(int range) {
        this.completeStuckBlockBreakRange = range;
        return this;
    }

    @Override
    public int getStuckLevel() {
        return this.stuckLevel;
    }
}

