/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.other;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.ICustomAttackSound;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.DamageSourceKeys;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpearEntity
extends ThrownTrident
implements ICustomAttackSound {
    private static final int MAX_LIVE_TIME = 200;
    private static final int GROUND_LIVE_TIME = 40;
    public static final int BASE_DAMAGE = 8;
    public static final String NBT_WEAPON = "Weapon";
    public static final String NBT_DEALT_DAMAGE = "DealtDamage";
    protected ItemStack weapon = new ItemStack((ItemLike)ModItems.spear);
    private boolean dealtDamage;

    public SpearEntity(EntityType<? extends ThrownTrident> type, Level world) {
        super(type, world);
    }

    public SpearEntity(Level world, LivingEntity thrower, ItemStack thrownWeapon) {
        super(ModEntities.SPEAR, world);
        this.weapon = thrownWeapon.copy();
        this.setOwner((Entity)thrower);
        this.setPos(thrower.getX(), thrower.getEyeY() - 0.1, thrower.getZ());
        this.shootFromRotation((Entity)thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, 2.5f, 1.0f);
    }

    @NotNull
    public ItemStack getPickupItem() {
        return this.weapon.copy();
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.findHitEntity(startVec, endVec);
    }

    protected void onHitEntity(EntityHitResult result) {
        ServerLevel serverlevel;
        Level level;
        Entity targetEntity = result.getEntity();
        Entity ownerEntity = this.getOwner();
        float damageAmount = 8.0f;
        DamageSource damageSource = this.level().damageSources().source(DamageSourceKeys.SPEAR, (Entity)this, (Entity)(ownerEntity == null ? this : ownerEntity));
        if (targetEntity instanceof LivingEntity && (level = this.level()) instanceof ServerLevel) {
            serverlevel = (ServerLevel)level;
            damageAmount += EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.weapon, (Entity)targetEntity, (DamageSource)damageSource, (float)damageAmount);
        }
        this.dealtDamage = true;
        if (targetEntity.hurt(damageSource, damageAmount)) {
            if (targetEntity.getType() == EntityType.ENDERMAN) {
                return;
            }
            level = this.level();
            if (level instanceof ServerLevel) {
                serverlevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel, (Entity)targetEntity, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
            }
            if (targetEntity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)targetEntity;
                this.doKnockback(livingentity, damageSource);
                this.doPostHurtEffects(livingentity);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.dealtDamage = nbt.getBoolean(NBT_DEALT_DAMAGE);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean(NBT_DEALT_DAMAGE, this.dealtDamage);
    }

    public void tick() {
        if (this.tickCount > 200) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.inGroundTime > 40) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        super.tick();
    }

    public void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED) {
            super.tickDespawn();
        }
    }

    protected float getWaterInertia() {
        return 0.9f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    @Override
    public SoundEvent getAttackSound() {
        return (SoundEvent)SoundEvents.TRIDENT_THROW.value();
    }

    public boolean save(@NotNull CompoundTag nbt) {
        return false;
    }

    public void load(@NotNull CompoundTag nbt) {
        this.discard();
    }
}

