/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.sounds.MercenarySounds;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.entity.mobs.EntityMercenary;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class EntityMercenaryAI
extends Goal {
    private static final int MAX_BLOCK_CHASE_DISTANCE = 50;
    private static final int MAX_STUCK_TIME = 10;
    private final ITickRateStateMachine<IState> stateMachine;
    private final EntityMercenary entity;
    private final List<BlockPos> patrolPoints;
    private BlockPos currentPatrolPos;
    private boolean movingToBuilding = false;
    private BlockPos lastWorkerPos;
    private PathResult attackPath;
    private int attacktimer = 0;
    private static final int ATTACK_DELAY = 5;
    private static final int MELEE_ATTACK_DIST = 2;
    private int stuckTimer = 0;
    private final Random rand = new Random();

    public EntityMercenaryAI(EntityMercenary entityMercenary) {
        this.entity = entityMercenary;
        this.patrolPoints = new LinkedList<BlockPos>();
        this.stateMachine = new TickRateStateMachine<State>(State.INIT, this::handleAIException);
        this.stateMachine.addTransition(new TickingTransition<IState>(State.INIT, this::initialize, () -> State.PATROLLING, 10));
        this.stateMachine.addTransition(new TickingTransition<IState>(State.PATROLLING, this::hasTarget, () -> State.FIGHTING, 5));
        this.stateMachine.addTransition(new TickingTransition<IState>(State.PATROLLING, this::patrol, () -> State.PATROLLING, 10));
        this.stateMachine.addTransition(new TickingTransition<IState>(State.FIGHTING, this::fighting, () -> State.PATROLLING, 5));
    }

    private boolean initialize() {
        if (this.entity.getColony() == null) {
            return false;
        }
        this.patrolPoints.addAll(this.entity.getColony().getBuildingManager().getBuildings().keySet());
        return true;
    }

    private boolean hasTarget() {
        if (this.entity.getTarget() != null && this.entity.getTarget().isAlive() && !(this.entity.getTarget() instanceof EntityMercenary)) {
            this.entity.getTarget().setLastHurtByMob((LivingEntity)this.entity);
            return true;
        }
        return false;
    }

    private boolean patrol() {
        if (this.currentPatrolPos == null || this.entity.getProxy().walkToBlock(this.currentPatrolPos, 3, true)) {
            ArrayList<IItemHandler> handlers;
            IItemHandler handler;
            ItemStack stack;
            IBuilding building;
            if (this.currentPatrolPos != null && this.movingToBuilding && (building = this.entity.getColony().getBuildingManager().getBuilding(this.currentPatrolPos)) != null && !ItemStackUtils.isEmpty(stack = (handler = (IItemHandler)(handlers = new ArrayList<IItemHandler>(InventoryUtils.getItemHandlersFromProvider(building.getTileEntity()))).get(this.rand.nextInt(handlers.size()))).extractItem(this.rand.nextInt(handler.getSlots()), 5, false))) {
                this.entity.swing(InteractionHand.OFF_HAND);
                MessageUtils.format("com.minecolonies.coremod.mercenary.stealbuilding", stack.getHoverName().getString()).sendTo(this.entity.getColony()).forAllPlayers();
            }
            if (this.rand.nextInt(4) == 0 && !this.patrolPoints.isEmpty()) {
                this.movingToBuilding = true;
                this.currentPatrolPos = this.patrolPoints.get(this.rand.nextInt(this.patrolPoints.size()));
            } else {
                this.movingToBuilding = false;
                this.currentPatrolPos = BlockPosUtil.getRandomPosition(this.entity.getCommandSenderWorld(), this.entity.blockPosition(), this.entity.blockPosition(), 10, 27);
            }
        }
        this.stuckTimer = this.entity.blockPosition().equals((Object)this.lastWorkerPos) ? ++this.stuckTimer : 0;
        if (this.stuckTimer > 10) {
            this.stuckTimer = 0;
            this.currentPatrolPos = null;
            this.entity.getNavigation().stop();
        }
        this.lastWorkerPos = this.entity.blockPosition();
        return true;
    }

    private boolean fighting() {
        int distance;
        if (this.entity.getTarget() == null || !this.entity.getTarget().isAlive()) {
            this.entity.getNavigation().stop();
            this.attackPath = null;
            return true;
        }
        if (this.attacktimer > 0) {
            --this.attacktimer;
        }
        if (this.attackPath == null || !this.attackPath.isInProgress()) {
            EntityNavigationUtils.walkToPos(this.entity, this.entity.getTarget().blockPosition(), false);
            this.entity.getLookControl().setLookAt((Entity)this.entity.getTarget());
        }
        if ((distance = BlockPosUtil.getMaxDistance2D(this.entity.blockPosition(), this.entity.getTarget().blockPosition())) < 2 && this.attacktimer == 0) {
            this.entity.swing(InteractionHand.MAIN_HAND);
            this.entity.playSound(MercenarySounds.mercenaryAttack, 0.55f, 1.0f);
            this.entity.getTarget().hurt(this.entity.level().damageSources().mobAttack((LivingEntity)this.entity), 15.0f);
            this.entity.getTarget().setRemainingFireTicks(60);
            this.attacktimer = 5;
        } else if (distance > 50) {
            this.entity.setTarget(null);
            this.entity.getNavigation().stop();
            this.attackPath = null;
            return true;
        }
        return false;
    }

    private void handleAIException(RuntimeException e) {
        Log.getLogger().error("MercenaryAI threw an exception:", (Throwable)e);
    }

    public boolean canUse() {
        return this.entity != null && this.entity.isAlive() && !this.entity.isInvisible() && this.entity.getColony() != null && this.entity.getState() == State.ALIVE;
    }

    public boolean canContinueToUse() {
        this.stateMachine.tick();
        return this.entity != null && this.entity.isAlive() && !this.entity.isInvisible() && this.entity.getColony() != null && this.entity.getState() == State.ALIVE;
    }

    public static enum State implements IState
    {
        INIT,
        SPAWN_EVENT,
        PATROLLING,
        FIGHTING,
        ALIVE,
        DEAD;

    }
}

