/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.herders;

import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingRabbitHutch;
import com.minecolonies.core.colony.jobs.JobRabbitHerder;
import com.minecolonies.core.entity.ai.workers.production.herders.AbstractEntityAIHerder;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkRabbitHerder
extends AbstractEntityAIHerder<JobRabbitHerder, BuildingRabbitHutch> {
    public static final String RENDER_META_CARROT = "carrot";

    public EntityAIWorkRabbitHerder(@NotNull JobRabbitHerder job) {
        super(job);
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.CARROT)) {
            renderMeta = (String)renderMeta + RENDER_META_CARROT;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    @Override
    public Class<BuildingRabbitHutch> getExpectedBuildingClass() {
        return BuildingRabbitHutch.class;
    }

    @Override
    protected void butcherAnimal(@Nullable Animal animal) {
        if (animal != null && !this.walkingToAnimal(animal) && !ItemStackUtils.isEmpty(this.worker.getMainHandItem())) {
            this.worker.swing(InteractionHand.MAIN_HAND);
            if (this.worker.getRandom().nextInt(1 + (100 - this.getPrimarySkillLevel()) / 5) <= 1) {
                DamageSource ds = animal.level().damageSources().playerAttack((Player)this.getFakePlayer());
                animal.hurt(ds, (float)this.getButcheringAttackDamage());
                CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, 1);
            }
        }
    }
}

