/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.minimal;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.modules.GraveyardManagementModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingGraveyard;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.tileentities.TileEntityNamedGrave;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.StringUtils;

public class EntityAIMournCitizen
implements IStateAI {
    private final EntityCitizen citizen;
    private final double speed;
    private Entity closestEntity;
    private static final int MIN_DESTINATION_TO_LOCATION = 225;
    private static final int AVERAGE_MOURN_TIME = 300;
    private static final int AVERAGE_STARE_TIME = 200;
    private IBuilding graveyard;
    private BlockPos gravePos;

    public EntityAIMournCitizen(EntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(CitizenAIState.MOURN, () -> {
            this.reset();
            return true;
        }, () -> MourningState.DECIDE, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.DECIDE, () -> true, this::decide, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.WALKING_TO_TOWNHALL, () -> true, this::walkToTownHall, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.WANDERING, () -> true, this::wander, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.STARING, () -> true, this::stare, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.WALKING_TO_GRAVEYARD, () -> true, this::walkToGraveyard, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.WANDER_AT_GRAVEYARD, () -> true, this::wanderAtGraveyard, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.WALK_TO_GRAVE, () -> true, this::walkToGrave, 20));
    }

    private IState walkToTownHall() {
        IBuilding building = this.getMournLocation();
        if (building == null) {
            return CitizenAIState.IDLE;
        }
        if (!EntityNavigationUtils.walkToBuilding(this.citizen, building)) {
            return MourningState.WALKING_TO_TOWNHALL;
        }
        return CitizenAIState.IDLE;
    }

    private IState walkToGraveyard() {
        if (this.graveyard == null) {
            return MourningState.DECIDE;
        }
        if (!EntityNavigationUtils.walkToBuilding(this.citizen, this.graveyard)) {
            return MourningState.WALKING_TO_GRAVEYARD;
        }
        return MourningState.WANDER_AT_GRAVEYARD;
    }

    private IState wanderAtGraveyard() {
        if (this.graveyard == null) {
            return MourningState.DECIDE;
        }
        if (!this.citizen.getNavigation().isDone()) {
            return MourningState.WANDER_AT_GRAVEYARD;
        }
        if (MathUtils.RANDOM.nextInt(100) < 90) {
            EntityNavigationUtils.walkToRandomPosWithin(this.citizen, 10, 0.6, this.graveyard.getCorners());
            return MourningState.WANDER_AT_GRAVEYARD;
        }
        Set<Tuple<BlockPos, Direction>> gravePositions = ((BuildingGraveyard)this.graveyard).getGravePositions();
        for (Tuple<BlockPos, Direction> gravePos : gravePositions) {
            Iterator<String> iterator;
            BlockEntity blockEntity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.citizen.level(), gravePos.getA()) || !((blockEntity = this.citizen.level().getBlockEntity(gravePos.getA())) instanceof TileEntityNamedGrave) || !(iterator = this.citizen.getCitizenData().getCitizenMournHandler().getDeceasedCitizens().iterator()).hasNext()) continue;
            String deathBud = iterator.next();
            String firstName = StringUtils.split((String)deathBud)[0];
            String lastName = deathBud.replaceFirst(firstName, "");
            ArrayList<String> graveNameList = ((TileEntityNamedGrave)blockEntity).getTextLines();
            if (graveNameList.isEmpty() || !graveNameList.contains(firstName) || !graveNameList.contains(lastName)) continue;
            this.gravePos = gravePos.getA();
            return MourningState.WALK_TO_GRAVE;
        }
        return MourningState.DECIDE;
    }

    private IState walkToGrave() {
        if (this.gravePos == null) {
            return MourningState.DECIDE;
        }
        if (!EntityNavigationUtils.walkToPosInBuilding(this.citizen, this.gravePos, this.graveyard, 3)) {
            return MourningState.WALK_TO_GRAVE;
        }
        return MourningState.DECIDE;
    }

    private IState wander() {
        EntityNavigationUtils.walkToRandomPos(this.citizen, 10, this.speed);
        return CitizenAIState.IDLE;
    }

    private IState stare() {
        if (this.citizen.getRandom().nextInt(200) < 1) {
            this.closestEntity = null;
            return CitizenAIState.IDLE;
        }
        if (this.closestEntity == null) {
            this.closestEntity = this.citizen.level().getNearestEntity(EntityCitizen.class, TargetingConditions.DEFAULT, (LivingEntity)this.citizen, this.citizen.getX(), this.citizen.getY(), this.citizen.getZ(), this.citizen.getBoundingBox().inflate(3.0, 3.0, 3.0));
            if (this.closestEntity == null) {
                return CitizenAIState.IDLE;
            }
        }
        this.citizen.getLookControl().setLookAt(this.closestEntity.getX(), this.closestEntity.getY() + (double)this.closestEntity.getEyeHeight(), this.closestEntity.getZ(), (float)this.citizen.getMaxHeadYRot(), (float)this.citizen.getMaxHeadXRot());
        return MourningState.STARING;
    }

    private IState decide() {
        IBuilding graveyardBuilding;
        if (!this.citizen.getNavigation().isDone()) {
            return CitizenAIState.IDLE;
        }
        if (this.citizen.getRandom().nextBoolean()) {
            return MourningState.STARING;
        }
        if (this.graveyard == null && (graveyardBuilding = this.citizen.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getFirstBuildingMatching(b -> b instanceof BuildingGraveyard && ((GraveyardManagementModule)b.getFirstModuleOccurance(GraveyardManagementModule.class)).hasRestingCitizen(this.citizen.getCitizenData().getCitizenMournHandler().getDeceasedCitizens()))) != null) {
            this.graveyard = graveyardBuilding;
        }
        if (this.graveyard != null) {
            return MourningState.WALKING_TO_GRAVEYARD;
        }
        this.citizen.getLookControl().setLookAt(this.citizen.getX(), this.citizen.getY() - 10.0, this.citizen.getZ(), (float)this.citizen.getMaxHeadYRot(), (float)this.citizen.getMaxHeadXRot());
        if (this.getMournLocation() != null && BlockPosUtil.getDistance2D(this.citizen.blockPosition(), this.getMournLocation().getPosition()) > 225L) {
            return MourningState.WALKING_TO_TOWNHALL;
        }
        return MourningState.WANDERING;
    }

    public void reset() {
        this.citizen.getCitizenData().setVisibleStatus(null);
        this.graveyard = null;
        this.gravePos = null;
    }

    protected IBuilding getMournLocation() {
        IColony colony = this.citizen.getCitizenColonyHandler().getColonyOrRegister();
        if (colony != null && colony.getBuildingManager().hasTownHall()) {
            return colony.getBuildingManager().getTownHall();
        }
        return this.citizen.getCitizenData().getHomeBuilding();
    }

    public static enum MourningState implements IState
    {
        DECIDE,
        WALKING_TO_TOWNHALL,
        WANDERING,
        STARING,
        WALKING_TO_GRAVEYARD,
        WANDER_AT_GRAVEYARD,
        WALK_TO_GRAVE;

    }
}

