/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.combat;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.items.ItemSpear;
import java.util.Map;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;

public class CombatUtils {
    private static final double AIM_HEIGHT = 2.0;
    private static final double ARROW_SPEED = 1.4;
    private static final double AIM_SLIGHTLY_HIGHER_MULTIPLIER = 0.18;
    private static final double SPEED_FOR_DIST = 35.0;

    public static AbstractArrow createArrowForShooter(LivingEntity shooter) {
        AbstractArrow arrowEntity = (AbstractArrow)ModEntities.MC_NORMAL_ARROW.create(shooter.level());
        ItemStack rangedWeapon = shooter.getItemInHand(InteractionHand.MAIN_HAND);
        Item rangedWeaponItem = rangedWeapon.getItem();
        arrowEntity.setOwner((Entity)shooter);
        if (rangedWeaponItem instanceof BowItem) {
            BowItem bow = (BowItem)rangedWeaponItem;
            arrowEntity = bow.customArrow(arrowEntity, ItemStack.EMPTY, rangedWeapon);
        } else if (rangedWeaponItem instanceof ItemSpear) {
            arrowEntity = (AbstractArrow)ModEntities.SPEAR.create(shooter.level());
        } else if (rangedWeaponItem instanceof TridentItem) {
            arrowEntity = (AbstractArrow)EntityType.TRIDENT.create(shooter.level());
        }
        arrowEntity.setOwner((Entity)shooter);
        arrowEntity.setPos(shooter.getX(), shooter.getY() + 1.0, shooter.getZ());
        return arrowEntity;
    }

    public static void shootArrow(AbstractArrow arrow, LivingEntity target, float hitChance) {
        double xVector = target.getX() - arrow.getX();
        double yVector = target.getBoundingBox().minY + (double)target.getBbHeight() / 2.0 - arrow.getY();
        double zVector = target.getZ() - arrow.getZ();
        double distance = Mth.sqrt((float)((float)(xVector * xVector + zVector * zVector)));
        double dist3d = Mth.sqrt((float)((float)(yVector * yVector + xVector * xVector + zVector * zVector)));
        arrow.shoot(xVector, yVector + distance * 0.18, zVector, (float)(1.4 + dist3d / 35.0), hitChance);
        target.level().addFreshEntity((Entity)arrow);
    }

    public static void notifyGuardsOfTarget(AbstractEntityCitizen user, LivingEntity target, int callRange) {
        for (ICitizenData iCitizenData : user.getCitizenData().getWorkBuilding().getAllAssignedCitizen()) {
            if (!iCitizenData.getEntity().isPresent() || iCitizenData.getEntity().get().getLastHurtByMob() != null) continue;
            ((EntityCitizen)iCitizenData.getEntity().get()).getThreatTable().addThreat(target, 0);
        }
        if (target instanceof AbstractEntityMinecoloniesRaider) {
            for (Map.Entry entry : user.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getBuildings().entrySet()) {
                if (!(entry.getValue() instanceof AbstractBuildingGuards) || !(user.blockPosition().distSqr((Vec3i)entry.getKey()) < (double)callRange)) continue;
                AbstractBuildingGuards building = (AbstractBuildingGuards)entry.getValue();
                building.setTempNextPatrolPoint(target.blockPosition());
            }
        }
    }
}

