/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.debug.messages;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.core.debug.DebugPlayerManager;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DebugEnablePathfindingMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"debug_togglepathfinding", DebugEnablePathfindingMessage::new);
    private int id;
    private boolean enable = false;

    public DebugEnablePathfindingMessage(ICitizenDataView citizen, boolean enable) {
        super(TYPE, citizen.getColony());
        this.id = citizen.getId();
        this.enable = enable;
    }

    protected DebugEnablePathfindingMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.id = buf.readInt();
        this.enable = buf.readBoolean();
    }

    @Override
    protected void toBytes(RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.id);
        buf.writeBoolean(this.enable);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        if (player == null || !DebugPlayerManager.hasDebugEnabled((Player)player)) {
            return;
        }
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.id);
        if (citizen == null || !citizen.getEntity().isPresent()) {
            return;
        }
        if (this.enable) {
            PathfindingUtils.trackingMap.put(player.getUUID(), citizen.getUUID());
        } else {
            PathfindingUtils.trackingMap.remove(player.getUUID());
        }
    }
}

