/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.datalistener.util.MappingResult;
import com.minecolonies.core.datalistener.util.ModRemovalorder;
import com.minecolonies.core.datalistener.util.OtherModsRemovalOrder;
import com.minecolonies.core.datalistener.util.RemovalOrder;
import com.minecolonies.core.datalistener.util.SingleEntryRemovalOrder;
import com.minecolonies.core.util.GsonHelper;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDataListener<T>
extends SimpleJsonResourceReloadListener {
    private static final String KEY_REMOVE = "remove";
    private static final String KEY_CONDITIONS = "neoforge:conditions";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final String name;
    private ImmutableMap<ResourceLocation, T> entries = ImmutableMap.of();

    protected BaseDataListener(String directory) {
        super(GSON, directory);
        this.name = StringUtils.capitalize((String)directory.replaceAll("_", " "));
    }

    protected final void apply(@NotNull Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        Log.getLogger().info("[{} Loader]: Starting reload...", (Object)this.name);
        long start = System.nanoTime();
        HashMap<ResourceLocation, T> newEntries = new HashMap<ResourceLocation, T>();
        HashSet<RemovalOrder> toRemove = new HashSet<RemovalOrder>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            ResourceLocation key = entry.getKey();
            if (!entry.getValue().isJsonObject()) {
                this.logWarning(key, String.format("Entry is not a JSON object, found %s", entry.getValue().getClass()));
                continue;
            }
            JsonObject value = entry.getValue().getAsJsonObject();
            try {
                toRemove.addAll(this.getRemovalOrders(key, value));
                List<ICondition> conditions = this.getConditions(value);
                if (!conditions.stream().allMatch(a -> a.test(this.getContext()))) continue;
                MappingResult<T> result = this.mapEntry(key, value);
                if (result.success()) {
                    newEntries.put(key, result.item());
                    continue;
                }
                this.logWarning(key, result.reason());
            }
            catch (Exception e) {
                Log.getLogger().error("[{} Loader]: Error loading entry with id {}.", (Object)this.name, (Object)key, (Object)e);
            }
        }
        Iterator iterator = newEntries.keySet().iterator();
        while (iterator.hasNext()) {
            ResourceLocation key = (ResourceLocation)iterator.next();
            boolean shouldRemove = toRemove.stream().anyMatch(order -> order.test(key));
            if (!shouldRemove) continue;
            iterator.remove();
        }
        Log.getLogger().info("[{} Loader]: Finished reloading. {} entries created.", (Object)this.name, (Object)newEntries.size());
        Log.getLogger().debug("[{} Loader]: Reloading finished in {} nanoseconds.", (Object)this.name, (Object)(System.nanoTime() - start));
        this.entries = ImmutableMap.copyOf(newEntries);
    }

    private void logWarning(ResourceLocation key, String reason) {
        Log.getLogger().warn("[{} Loader]: Problem loading entry with id {}: {}", (Object)this.name, (Object)key, (Object)reason);
    }

    private List<RemovalOrder> getRemovalOrders(ResourceLocation key, JsonObject object) {
        ArrayList<RemovalOrder> orders = new ArrayList<RemovalOrder>();
        JsonArray remove = GsonHelper.getAsJsonArray((JsonObject)object, (String)KEY_REMOVE, (JsonArray)new JsonArray());
        for (JsonElement element : remove) {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) continue;
            String text = element.getAsString();
            if (text.equals("*")) {
                orders.add(new OtherModsRemovalOrder(key.getNamespace()));
            } else if (text.matches("\\w+:\\*")) {
                orders.add(new ModRemovalorder(StringUtils.substringBefore((String)text, (String)":")));
            }
            if (ResourceLocation.tryParse((String)text) == null) continue;
            orders.add(new SingleEntryRemovalOrder(ResourceLocation.tryParse((String)text)));
        }
        return orders;
    }

    private List<ICondition> getConditions(JsonObject object) {
        DataResult parse;
        if (object.has(KEY_CONDITIONS) && (parse = ICondition.LIST_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)object.get(KEY_CONDITIONS))).isSuccess()) {
            return (List)((Pair)parse.getOrThrow()).getFirst();
        }
        return List.of();
    }

    @NotNull
    protected abstract MappingResult<T> mapEntry(ResourceLocation var1, JsonObject var2);

    public Map<ResourceLocation, T> getEntries() {
        return this.entries;
    }
}

