/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei;

import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.core.compatibility.jei.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FishermanRecipeCategory
extends JobBasedRecipeCategory<FishingRecipe> {
    private static final int LOOT_SLOTS_X = 53;
    private static final int LOOT_SLOTS_W = 114;

    public FishermanRecipeCategory(@NotNull IGuiHelper guiHelper) {
        super(((JobEntry)ModJobs.fisherman.get()).produceJob(null), ModRecipeTypes.FISHING, new ItemStack(((BuildingEntry)ModBuildings.fisherman.get()).getBuildingBlock()), guiHelper);
    }

    @Override
    @NotNull
    protected List<Component> generateInfoBlocks(@NotNull FishingRecipe recipe) {
        return Collections.singletonList(Component.translatableEscape((String)"com.minecolonies.coremod.jei.onelevelrestriction", (Object[])new Object[]{recipe.getLevel()}));
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull FishingRecipe recipe, @NotNull IFocusGroup focuses) {
        this.addToolSlot(builder, (EquipmentTypeEntry)ModEquipmentTypes.fishing_rod.get(), 149, 26, true);
        if (!recipe.getDrops().isEmpty()) {
            int startX;
            int initialColumns = 114 / this.slot.getWidth();
            int rows = Math.max(1, (recipe.getDrops().size() + initialColumns - 1) / initialColumns);
            int columns = (recipe.getDrops().size() + rows - 1) / rows;
            int x = startX = 53 + (114 - columns * this.slot.getWidth()) / 2;
            int y = 117 - rows * this.slot.getHeight() + 1;
            int c = 0;
            for (LootTableAnalyzer.LootDrop drop : recipe.getDrops()) {
                ((IRecipeSlotBuilder)builder.addOutputSlot(x, y).setBackground((IDrawable)this.chanceSlot, -1, -1).addItemStacks(drop.getItemStacks())).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)new JobBasedRecipeCategory.LootTableTooltipCallback(drop, recipe.getId()));
                if (++c >= columns) {
                    c = 0;
                    x = startX;
                    y += this.slot.getHeight();
                    continue;
                }
                x += this.slot.getWidth();
            }
        }
    }

    @NotNull
    public static List<FishingRecipe> findRecipes() {
        List<LootTableAnalyzer.LootDrop> commonDrops = CustomRecipeManager.getInstance().getLootDrops(ModLootTables.FISHING);
        ArrayList<FishingRecipe> recipes = new ArrayList<FishingRecipe>();
        for (Map.Entry<Integer, ResourceKey<LootTable>> level : ModLootTables.FISHERMAN_BONUS.entrySet()) {
            ArrayList<LootTableAnalyzer.LootDrop> drops = new ArrayList<LootTableAnalyzer.LootDrop>(commonDrops);
            drops.addAll(CustomRecipeManager.getInstance().getLootDrops(level.getValue()));
            recipes.add(new FishingRecipe(level.getValue(), level.getKey(), drops));
        }
        return recipes;
    }

    public static class FishingRecipe {
        private final ResourceKey<LootTable> id;
        private final int level;
        @NotNull
        private final List<LootTableAnalyzer.LootDrop> drops;

        public FishingRecipe(@NotNull ResourceKey<LootTable> id, int level, @NotNull List<LootTableAnalyzer.LootDrop> drops) {
            this.id = id;
            this.level = level;
            this.drops = drops.size() > 18 ? LootTableAnalyzer.consolidate(drops) : drops;
        }

        @NotNull
        public ResourceKey<LootTable> getId() {
            return this.id;
        }

        public int getLevel() {
            return this.level;
        }

        @NotNull
        public List<LootTableAnalyzer.LootDrop> getDrops() {
            return this.drops;
        }
    }
}

