/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.generalcommands;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.BlockPosUtil;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.ScanToolData;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.core.network.messages.client.SaveStructureNBTMessage;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanCommand
extends AbstractCommand {
    public static final String NAME = "scan";
    private static final String PLAYER_NOT_FOUND = "com.structurize.command.playernotfound";
    private static final String SCAN_SUCCESS_MESSAGE = "com.structurize.command.scan.success";
    private static final String NO_PERMISSION_MESSAGE = "com.structurize.command.scan.no.perm";
    public static final String FILE_NAME = "filename";
    public static final String PLAYER_NAME = "player";
    public static final String POS1 = "pos1";
    public static final String POS2 = "pos2";
    public static final String ANCHOR_POS = "anchor_pos";

    public static void saveStructure(Level world, Player player, ScanToolData.Slot slot, boolean saveEntities) {
        boolean isHut;
        List list;
        String[] split;
        if (slot.box().anchor().isPresent() && !BlockPosUtil.isInbetween((BlockPos)((BlockPos)slot.box().anchor().get()), (BlockPos)slot.box().pos1(), (BlockPos)slot.box().pos2())) {
            player.displayClientMessage((Component)Component.translatable((String)"item.sceptersteel.badanchorpos"), false);
            return;
        }
        BoundingBox box = BoundingBox.fromCorners((Vec3i)slot.box().pos1(), (Vec3i)slot.box().pos2());
        if (box.getXSpan() * box.getYSpan() * box.getZSpan() > (Integer)((ServerConfiguration)Structurize.getConfig().getServer()).schematicBlockLimit.get()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.sceptersteel.toobig", (Object[])new Object[]{((ServerConfiguration)Structurize.getConfig().getServer()).schematicBlockLimit.get()}), false);
            return;
        }
        Object fileName = slot.name().isEmpty() ? Component.translatable((String)"item.sceptersteel.scanformat", (Object[])new Object[]{new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(Date.from(Instant.now()))}).getString() : slot.name();
        if (!((String)fileName).contains(".blueprint")) {
            fileName = (String)fileName + ".blueprint";
        }
        String style = (split = ((String)fileName).split("/")).length <= 1 ? "" : split[0];
        BlockPos zero = new BlockPos(box.minX(), box.minY(), box.minZ());
        Blueprint bp = BlueprintUtil.createBlueprint((Level)world, (BlockPos)zero, (boolean)saveEntities, (short)((short)box.getXSpan()), (short)((short)box.getYSpan()), (short)((short)box.getZSpan()), (String)fileName, (Optional)slot.box().anchor());
        if (slot.box().anchor().isEmpty() && bp.getPrimaryBlockOffset().equals((Object)new BlockPos(bp.getSizeX() / 2, 0, bp.getSizeZ() / 2)) && (list = bp.getBlockInfoAsList().stream().filter(blockInfo -> blockInfo.hasTileEntityData() && blockInfo.getTileEntityData().contains("blueprintDataProvider")).collect(Collectors.toList())).size() > 1) {
            player.displayClientMessage((Component)Component.translatableEscape((String)"com.ldtteam.structurize.gui.scantool.scanbadanchor", (Object[])new Object[]{fileName}), false);
        }
        new SaveScanMessage(BlueprintUtil.writeBlueprintToNBT((Blueprint)bp), ((String)fileName).toLowerCase(Locale.US)).sendToPlayer((ServerPlayer)player);
        if (style.isEmpty()) {
            return;
        }
        boolean hasJigsaw = false;
        for (BlockState state : bp.getPalette()) {
            if (state.getBlock() != Blocks.JIGSAW) continue;
            hasJigsaw = true;
            break;
        }
        if (!hasJigsaw) {
            return;
        }
        BlockState primary = world.getBlockState(zero.offset((Vec3i)bp.getPrimaryBlockOffset()));
        if (primary.getBlock() instanceof AbstractBlockHut) {
            isHut = true;
            AbstractTileEntityColonyBuilding building = (AbstractTileEntityColonyBuilding)world.getBlockEntity(zero.offset((Vec3i)bp.getPrimaryBlockOffset()));
            building.addTag(new BlockPos(0, 0, 0), "deactivated");
            building.setPackName(style);
            building.setBlueprintPath(((String)fileName).replace(style + "/", ""));
        } else {
            isHut = false;
        }
        int lowestY = box.maxY();
        String piecesName = style.replace(" ", "").toLowerCase(Locale.US);
        for (BlockPos mutablePos : BlockPos.betweenClosed((BlockPos)zero, (BlockPos)zero.offset(box.getXSpan() - 1, box.getYSpan() - 1, box.getZSpan() - 1))) {
            JigsawBlockEntity jigsawBlockEntity;
            BlockState state = world.getBlockState(mutablePos);
            if (state.getBlock() != Blocks.JIGSAW) continue;
            if (mutablePos.getY() < lowestY) {
                lowestY = mutablePos.getY();
            }
            if ((jigsawBlockEntity = (JigsawBlockEntity)world.getBlockEntity(mutablePos)).getName().getPath().isEmpty() || jigsawBlockEntity.getName().getPath().equals("empty")) {
                if (jigsawBlockEntity.getFinalState().equals("minecraft:air")) {
                    jigsawBlockEntity.setFinalState("minecraft:structure_void");
                }
                if (isHut) {
                    jigsawBlockEntity.setPool(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation("minecolonies", piecesName + "/roads")));
                    jigsawBlockEntity.setName(new ResourceLocation("minecolonies", "building_entrance"));
                    jigsawBlockEntity.setTarget(new ResourceLocation("minecolonies", "building_entrance"));
                } else if (jigsawBlockEntity.getPool().location().getPath().contains("building")) {
                    jigsawBlockEntity.setPool(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation("minecolonies", piecesName + "/buildings")));
                    jigsawBlockEntity.setName(new ResourceLocation("minecolonies", "building_entrance"));
                    jigsawBlockEntity.setTarget(new ResourceLocation("minecolonies", "building_entrance"));
                } else {
                    jigsawBlockEntity.setPool(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation("minecolonies", piecesName + "/roads")));
                    jigsawBlockEntity.setName(new ResourceLocation("minecolonies", "street"));
                    jigsawBlockEntity.setTarget(new ResourceLocation("minecolonies", "street"));
                }
            }
            jigsawBlockEntity.setChanged();
            world.sendBlockUpdated(mutablePos, state, state, 3);
        }
        StructureTemplateManager structuretemplatemanager = ((ServerLevel)world).getStructureManager();
        BlockPos newZero = new BlockPos(zero.getX(), Math.max(zero.getY(), lowestY - 1), zero.getZ());
        int yDif = newZero.getY() - zero.getY();
        try {
            ResourceLocation location = new ResourceLocation("structurize", ((String)fileName).replace(".blueprint", "").replace(" ", "").toLowerCase(Locale.US));
            StructureTemplate structuretemplate = structuretemplatemanager.getOrCreate(location);
            structuretemplate.fillFromWorld(world, newZero, (Vec3i)new BlockPos(box.getXSpan(), box.getYSpan() - yDif, box.getZSpan()), false, Blocks.STRUCTURE_VOID);
            new SaveStructureNBTMessage(structuretemplate.save(new CompoundTag()), ((String)fileName).replace(".blueprint", ".nbt").toLowerCase(Locale.US)).sendToPlayer((ServerPlayer)player);
        }
        catch (ResourceLocationException resLocEx) {
            Log.getLogger().warn("Couldnt save nbt.");
        }
        if (isHut) {
            AbstractTileEntityColonyBuilding building = (AbstractTileEntityColonyBuilding)world.getBlockEntity(zero.offset((Vec3i)bp.getPrimaryBlockOffset()));
            building.removeTag(new BlockPos(0, 0, 0), "deactivated");
        }
    }

    private static int execute(CommandSourceStack source, BlockPos from, BlockPos to, Optional<BlockPos> anchorPos, GameProfile profile, String name) throws CommandSyntaxException {
        ServerPlayer player;
        @Nullable ServerLevel world = source.getLevel();
        if (source.getEntity() instanceof Player && !source.getPlayerOrException().isCreative()) {
            source.sendFailure((Component)Component.literal((String)NO_PERMISSION_MESSAGE));
        }
        if (profile != null && world.getServer() != null) {
            player = world.getServer().getPlayerList().getPlayer(profile.getId());
            if (player == null) {
                source.sendFailure((Component)Component.translatableEscape((String)PLAYER_NOT_FOUND, (Object[])new Object[]{profile.getName()}));
                return 0;
            }
        } else if (source.getEntity() instanceof Player) {
            player = source.getPlayerOrException();
        } else {
            source.sendFailure((Component)Component.translatableEscape((String)PLAYER_NOT_FOUND, (Object[])new Object[0]));
            return 0;
        }
        ScanCommand.saveStructure((Level)world, (Player)player, new ScanToolData.Slot(name, new BoxPreviewData(from, to, anchorPos)), true);
        source.sendFailure((Component)Component.translatableEscape((String)SCAN_SUCCESS_MESSAGE, (Object[])new Object[0]));
        return 1;
    }

    private static int onExecute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.getSpawnablePos(context, (String)POS1);
        BlockPos to = BlockPosArgument.getSpawnablePos(context, (String)POS2);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.empty(), null, null);
    }

    private static int onExecuteWithAnchor(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.getSpawnablePos(context, (String)POS1);
        BlockPos to = BlockPosArgument.getSpawnablePos(context, (String)POS2);
        BlockPos anchorPos = BlockPosArgument.getSpawnablePos(context, (String)ANCHOR_POS);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.of(anchorPos), null, null);
    }

    private static int onExecuteWithPlayerName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.getSpawnablePos(context, (String)POS1);
        BlockPos to = BlockPosArgument.getSpawnablePos(context, (String)POS2);
        GameProfile profile = GameProfileArgument.getGameProfiles(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.empty(), profile, null);
    }

    private static int onExecuteWithPlayerNameAndFileName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.getSpawnablePos(context, (String)POS1);
        BlockPos to = BlockPosArgument.getSpawnablePos(context, (String)POS2);
        GameProfile profile = GameProfileArgument.getGameProfiles(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        String name = StringArgumentType.getString(context, (String)FILE_NAME);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.empty(), profile, name);
    }

    private static int onExecuteWithPlayerNameAndFileNameAndAnchorPos(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.getSpawnablePos(context, (String)POS1);
        BlockPos to = BlockPosArgument.getSpawnablePos(context, (String)POS2);
        BlockPos anchorPos = BlockPosArgument.getSpawnablePos(context, (String)ANCHOR_POS);
        GameProfile profile = GameProfileArgument.getGameProfiles(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        String name = StringArgumentType.getString(context, (String)FILE_NAME);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.of(anchorPos), profile, name);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)ScanCommand.newLiteral((String)NAME).then(ScanCommand.newArgument((String)POS1, (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ScanCommand.newArgument((String)POS2, (ArgumentType)BlockPosArgument.blockPos()).executes(ScanCommand::onExecute)).then(ScanCommand.newArgument((String)ANCHOR_POS, (ArgumentType)BlockPosArgument.blockPos()).executes(ScanCommand::onExecuteWithAnchor))).then(((RequiredArgumentBuilder)ScanCommand.newArgument((String)PLAYER_NAME, (ArgumentType)GameProfileArgument.gameProfile()).executes(ScanCommand::onExecuteWithPlayerName)).then(((RequiredArgumentBuilder)ScanCommand.newArgument((String)FILE_NAME, (ArgumentType)StringArgumentType.string()).executes(ScanCommand::onExecuteWithPlayerNameAndFileName)).then(ScanCommand.newArgument((String)ANCHOR_POS, (ArgumentType)BlockPosArgument.blockPos()).executes(ScanCommand::onExecuteWithPlayerNameAndFileNameAndAnchorPos))))));
    }

    @NotNull
    public static String format(@NotNull ScanToolData.Slot slot) {
        String name = slot.name().chars().anyMatch(c -> !StringReader.isAllowedInUnquotedString((char)((char)c))) ? StringTag.quoteAndEscape((String)slot.name()) : slot.name();
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("/%s %s %s %s @p %s", "structurize", NAME, BlockPosUtil.format((BlockPos)slot.box().pos1()), BlockPosUtil.format((BlockPos)slot.box().pos2()), name));
        if (slot.box().anchor().isPresent() && BlockPosUtil.isInbetween((BlockPos)((BlockPos)slot.box().anchor().get()), (BlockPos)slot.box().pos1(), (BlockPos)slot.box().pos2())) {
            builder.append(' ');
            builder.append(BlockPosUtil.format((BlockPos)((BlockPos)slot.box().anchor().get())));
        }
        return builder.toString();
    }
}

