/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;

public class CommandShowClaim
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition());
        try {
            pos = BlockPosArgument.getBlockPos(context, (String)"location");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LevelChunk chunk = (LevelChunk)level.getChunk(pos);
        BlockPos finalPos = pos;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> this.buildClaimCommandResult(chunk, finalPos, level), true);
        return 1;
    }

    private MutableComponent buildClaimCommandResult(LevelChunk chunk, BlockPos pos, ServerLevel level) {
        Map<Integer, Set<BlockPos>> buildingClaims;
        MutableComponent text = Component.translatableEscape((String)"Claim data of chunk at: %sX %sZ\n", (Object[])new Object[]{pos.getX(), pos.getZ()}).withStyle(ChatFormatting.DARK_AQUA);
        List<Integer> staticColonyClaims = ColonyUtils.getStaticClaims((ChunkAccess)chunk);
        int owningColony = ColonyUtils.getOwningColony((ChunkAccess)chunk);
        if (!staticColonyClaims.isEmpty()) {
            text.append((Component)Component.translatableEscape((String)"OwnerID:%s Direct colony claims:\n", (Object[])new Object[]{owningColony}).withStyle(ChatFormatting.GOLD));
            for (int colonyID : staticColonyClaims) {
                IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)level.dimension());
                if (colony == null) {
                    text.append((Component)Component.translatableEscape((String)"ID: %s Name: Unkown Colony\n", (Object[])new Object[]{colonyID}));
                    continue;
                }
                text.append((Component)Component.translatableEscape((String)"ID: %s Name: %s\n", (Object[])new Object[]{colonyID, colony.getName()}));
            }
        }
        if (!(buildingClaims = ColonyUtils.getAllClaimingBuildings((ChunkAccess)chunk)).isEmpty()) {
            text.append((Component)Component.translatableEscape((String)"Building claims:\n", (Object[])new Object[0]).withStyle(ChatFormatting.GOLD));
            for (Map.Entry<Integer, Set<BlockPos>> entry : buildingClaims.entrySet()) {
                IColony colony = IColonyManager.getInstance().getColonyByDimension(entry.getKey(), (ResourceKey<Level>)level.dimension());
                for (BlockPos buildingPos : entry.getValue()) {
                    if (colony != null) {
                        IBuilding building = colony.getBuildingManager().getBuilding(buildingPos);
                        if (building != null) {
                            text.append((Component)Component.translatableEscape((String)"ID: %s Building: %s Pos: %s\n", (Object[])new Object[]{entry.getKey(), Component.translatableEscape((String)building.getBuildingDisplayName(), (Object[])new Object[0]), buildingPos}));
                            continue;
                        }
                        text.append((Component)Component.translatableEscape((String)"ID: %s Building: Unknown pos: %s\n", (Object[])new Object[]{entry.getKey(), buildingPos}));
                        continue;
                    }
                    text.append((Component)Component.translatableEscape((String)"ID: %s Building: Unknown Pos: %s\n", (Object[])new Object[]{entry.getKey(), buildingPos}));
                }
            }
        }
        return text;
    }

    @Override
    public String getName() {
        return "claiminfo";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("location", BlockPosArgument.blockPos()).executes(this::checkPreConditionAndExecute))).executes(this::checkPreConditionAndExecute);
    }
}

