/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class CommandCitizenTriggerWalkTo
implements IMCColonyOfficerCommand {
    static Map<UUID, BlockPos> walkingPosMap = new HashMap<UUID, BlockPos>();

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        IColony colony = ColonyIdArgument.getColony(context, "colonyID");
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.citizeninfo.notfound", (Object[])new Object[0]), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.citizeninfo.notloaded", (Object[])new Object[0]), true);
            return 0;
        }
        AbstractEntityCitizen entityCitizen = optionalEntityCitizen.get();
        Coordinates targetLocation = Vec3Argument.getCoordinates(context, (String)"location");
        final BlockPos targetPos = targetLocation.getBlockPos((CommandSourceStack)context.getSource());
        if (((CommandSourceStack)context.getSource()).getLevel() == entityCitizen.level()) {
            if (entityCitizen instanceof EntityCitizen && entityCitizen.getCitizenJobHandler().getColonyJob() != null) {
                final UUID uuid = sender == null ? UUID.fromString("unknown") : sender.getUUID();
                walkingPosMap.put(uuid, targetPos);
                long start = entityCitizen.level().getGameTime();
                AIOneTimeEventTarget<IState> currentTarget = new AIOneTimeEventTarget<IState>(this, () -> {
                    if (targetPos.equals((Object)walkingPosMap.get(uuid)) && !EntityNavigationUtils.walkToPos(entityCitizen, targetPos, 4, true) && entityCitizen.level().getGameTime() - start < 3600L) {
                        return ((EntityCitizen)entityCitizen).getCitizenAI().getState();
                    }
                    ((MinecoloniesAdvancedPathNavigate)entityCitizen.getNavigation()).setPauseTicks(100);
                    walkingPosMap.remove(uuid);
                    return ((EntityCitizen)entityCitizen).getCitizenAI().getState();
                }){

                    @Override
                    public boolean shouldRemove() {
                        return !targetPos.equals((Object)walkingPosMap.get(uuid));
                    }
                };
                ((EntityCitizen)entityCitizen).getCitizenAI().addTransition(currentTarget);
            } else {
                entityCitizen.getNavigation().moveTo(targetPos.getX(), targetPos.getY(), targetPos.getZ(), 1.0);
            }
        }
        return 1;
    }

    @Override
    public String getName() {
        return "walk";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newLiteral("stop").executes(this::stop))).then(IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("location", Vec3Argument.vec3()).executes(this::checkPreConditionAndExecute))));
    }

    private int stop(CommandContext<CommandSourceStack> context) {
        UUID uuid = ((CommandSourceStack)context.getSource()).getEntity() == null ? UUID.fromString("unknown") : ((CommandSourceStack)context.getSource()).getEntity().getUUID();
        walkingPosMap.remove(uuid);
        return 1;
    }
}

